/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.Closeable;
import java.io.IOException;

public interface GraphIndex
extends AutoCloseable,
Accountable {
    public int size();

    public NodesIterator getNodes();

    public View getView();

    public int maxDegree();

    default public int getIdUpperBound() {
        return this.size();
    }

    default public boolean containsNode(int nodeId) {
        return nodeId >= 0 && nodeId < this.size();
    }

    @Override
    public void close() throws IOException;

    public static String prettyPrint(GraphIndex graph) {
        StringBuilder sb = new StringBuilder();
        sb.append(graph);
        sb.append("\n");
        try (View view = graph.getView();){
            NodesIterator it = graph.getNodes();
            while (it.hasNext()) {
                int node = it.nextInt();
                sb.append("  ").append(node).append(" -> ");
                NodesIterator neighbors = view.getNeighborsIterator(node);
                while (neighbors.hasNext()) {
                    sb.append(" ").append(neighbors.nextInt());
                }
                sb.append("\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static interface View
    extends Closeable {
        public NodesIterator getNeighborsIterator(int var1);

        public int size();

        public int entryNode();

        public Bits liveNodes();

        default public int getIdUpperBound() {
            return this.size();
        }
    }

    public static interface ScoringView
    extends View {
        public ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> var1, VectorSimilarityFunction var2);

        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> var1, VectorSimilarityFunction var2);
    }
}

