/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.ConcurrentNeighborSet;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.DenseIntMap;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.util.ThreadSafeGrowableBitSet;
import java.io.DataOutput;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.IntStream;

public class OnHeapGraphIndex
implements GraphIndex {
    static final int NO_ENTRY_POINT = -1;
    private final AtomicInteger entryPoint = new AtomicInteger(-1);
    private final DenseIntMap<ConcurrentNeighborSet> nodes;
    private final ThreadSafeGrowableBitSet deletedNodes = new ThreadSafeGrowableBitSet(0);
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    final int maxDegree;
    private final int maxOverflowDegree;
    private final BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory;

    OnHeapGraphIndex(int M, int maxOverflowDegree, BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory) {
        this.maxDegree = M;
        this.maxOverflowDegree = maxOverflowDegree;
        this.neighborFactory = neighborFactory;
        this.nodes = new DenseIntMap(1024);
    }

    ConcurrentNeighborSet getNeighbors(int node) {
        return this.nodes.get(node);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public ConcurrentNeighborSet addNode(int node) {
        ConcurrentNeighborSet newNeighborSet = this.neighborFactory.apply(node, this.maxDegree());
        this.addNode(node, newNeighborSet);
        return newNeighborSet;
    }

    void addNode(int node, ConcurrentNeighborSet neighbors) {
        assert (neighbors != null);
        this.nodes.put(node, neighbors);
        this.maxNodeId.accumulateAndGet(node, Math::max);
    }

    public void markDeleted(int node) {
        this.deletedNodes.set(node);
    }

    void maybeSetInitialEntryNode(int node) {
        this.entryPoint.accumulateAndGet(node, (oldEntry, newEntry) -> {
            if (oldEntry >= 0) {
                return oldEntry;
            }
            return newEntry;
        });
    }

    void updateEntryNode(int node) {
        this.entryPoint.set(node);
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    int entry() {
        return this.entryPoint.get();
    }

    @Override
    public NodesIterator getNodes() {
        return this.nodes.getNodesIterator();
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long neighborSize = this.ramBytesUsedOneNode() * (long)this.size();
        return (long)OH_BYTES + (long)REF_BYTES * 2L + (long)AH_BYTES + neighborSize;
    }

    public long ramBytesUsedOneNode() {
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return (long)REF_BYTES + ConcurrentNeighborSet.ramBytesUsed(this.maxOverflowDegree + 1);
    }

    public String toString() {
        return String.format("OnHeapGraphIndex(size=%d, entryPoint=%d)", this.size(), this.entryPoint.get());
    }

    @Override
    public void close() {
    }

    @Override
    public ConcurrentGraphIndexView getView() {
        return new ConcurrentGraphIndexView();
    }

    void validateEntryNode() {
        if (this.size() == 0) {
            return;
        }
        int en = this.entryPoint.get();
        if (en < 0 || this.getNeighbors(en) == null) {
            throw new IllegalStateException("Entry node was incompletely added! " + en);
        }
    }

    public ThreadSafeGrowableBitSet getDeletedNodes() {
        return this.deletedNodes;
    }

    boolean removeNode(int node) {
        try {
            boolean bl = this.nodes.remove(node) != null;
            return bl;
        }
        finally {
            this.deletedNodes.clear(node);
        }
    }

    @Override
    public int getIdUpperBound() {
        return this.maxNodeId.get() + 1;
    }

    @Override
    public boolean containsNode(int nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public double getAverageShortEdges() {
        return IntStream.range(0, this.getIdUpperBound()).filter(this::containsNode).mapToDouble(i -> this.getNeighbors(i).getShortEdges()).average().orElse(Double.NaN);
    }

    public double getAverageDegree() {
        return IntStream.range(0, this.getIdUpperBound()).filter(this::containsNode).mapToDouble(i -> this.getNeighbors(i).size()).average().orElse(Double.NaN);
    }

    public void save(DataOutput out) {
        if (this.deletedNodes.cardinality() > 0) {
            throw new IllegalStateException("Cannot save a graph that has deleted nodes.  Call cleanup() first");
        }
        try (ConcurrentGraphIndexView view = this.getView();){
            out.writeInt(this.size());
            out.writeInt(view.entryNode());
            out.writeInt(this.maxDegree());
            for (Map.Entry<Integer, ConcurrentNeighborSet> entry : this.nodes.entrySet()) {
                int i = (int)((long)entry.getKey().intValue());
                NodesIterator neighbors = entry.getValue().iterator();
                out.writeInt(i);
                out.writeInt(neighbors.size());
                for (int n = 0; n < neighbors.size(); ++n) {
                    out.writeInt(neighbors.nextInt());
                }
                assert (!neighbors.hasNext());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class ConcurrentGraphIndexView
    implements GraphIndex.View {
        @Override
        public NodesIterator getNeighborsIterator(int node) {
            ConcurrentNeighborSet neighbors = OnHeapGraphIndex.this.getNeighbors(node);
            assert (neighbors != null) : "Node " + node + " not found";
            return neighbors.iterator();
        }

        @Override
        public int size() {
            return OnHeapGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnHeapGraphIndex.this.entryPoint.get();
        }

        public String toString() {
            return "OnHeapGraphIndexView(size=" + this.size() + ", entryPoint=" + OnHeapGraphIndex.this.entryPoint.get();
        }

        @Override
        public Bits liveNodes() {
            return OnHeapGraphIndex.this.deletedNodes.cardinality() == 0 ? Bits.ALL : Bits.inverseOf(OnHeapGraphIndex.this.deletedNodes);
        }

        @Override
        public int getIdUpperBound() {
            return OnHeapGraphIndex.this.getIdUpperBound();
        }

        @Override
        public void close() {
        }
    }
}

