/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;

class Header {
    final CommonHeader common;
    final EnumMap<FeatureId, ? extends Feature> features;

    Header(CommonHeader common, EnumMap<FeatureId, ? extends Feature> features) {
        this.common = common;
        this.features = features;
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(-62111);
        this.common.write(out);
        out.writeInt(FeatureId.serialize(EnumSet.copyOf(this.features.keySet())));
        for (Feature feature : this.features.values()) {
            feature.writeHeader(out);
        }
    }

    static Header load(RandomAccessReader reader, long offset) throws IOException {
        CommonHeader common;
        EnumSet<FeatureId> featureIds;
        reader.seek(offset);
        int maybeMagic = reader.readInt();
        EnumMap<FeatureId, Feature> features = new EnumMap<FeatureId, Feature>(FeatureId.class);
        if (maybeMagic != -62111) {
            int version = 0;
            featureIds = EnumSet.of(FeatureId.INLINE_VECTORS);
            int dimension = reader.readInt();
            int entryNode = reader.readInt();
            int maxDegree = reader.readInt();
            common = new CommonHeader(version, maybeMagic, dimension, entryNode, maxDegree);
        } else {
            common = CommonHeader.load(reader);
            featureIds = FeatureId.deserialize(reader.readInt());
        }
        for (FeatureId featureId : featureIds) {
            features.put(featureId, featureId.load(common, reader));
        }
        return new Header(common, features);
    }
}

