/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.pq.LocallyAdaptiveVectorQuantization;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorUtilSupport;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.List;

public final class VectorUtil {
    private static final VectorUtilSupport impl = VectorizationProvider.getInstance().getVectorUtilSupport();

    private VectorUtil() {
    }

    public static float dotProduct(VectorFloat<?> a, VectorFloat<?> b) {
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length() + "!=" + b.length());
        }
        float r = impl.dotProduct(a, b);
        assert (Float.isFinite(r)) : String.format("dotProduct(%s, %s) = %s", a, b, Float.valueOf(r));
        return r;
    }

    public static float dotProduct(VectorFloat<?> a, int aoffset, VectorFloat<?> b, int boffset, int length) {
        float r = impl.dotProduct(a, aoffset, b, boffset, length);
        assert (Float.isFinite(r)) : String.format("dotProduct(%s, %s) = %s", a, b, Float.valueOf(r));
        return r;
    }

    public static float cosine(VectorFloat<?> a, VectorFloat<?> b) {
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length() + "!=" + b.length());
        }
        float r = impl.cosine(a, b);
        assert (Float.isFinite(r)) : String.format("cosine(%s, %s) = %s", a, b, Float.valueOf(r));
        return r;
    }

    public static float squareL2Distance(VectorFloat<?> a, VectorFloat<?> b) {
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length() + "!=" + b.length());
        }
        float r = impl.squareDistance(a, b);
        assert (Float.isFinite(r)) : String.format("squareDistance(%s, %s) = %s", a, b, Float.valueOf(r));
        return r;
    }

    public static float squareL2Distance(VectorFloat<?> a, int aoffset, VectorFloat<?> b, int boffset, int length) {
        float r = impl.squareDistance(a, aoffset, b, boffset, length);
        assert (Float.isFinite(r));
        return r;
    }

    public static void l2normalize(VectorFloat<?> v) {
        double squareSum = VectorUtil.dotProduct(v, v);
        if (squareSum == 0.0) {
            throw new IllegalArgumentException("Cannot normalize a zero-length vector");
        }
        double length = Math.sqrt(squareSum);
        VectorUtil.scale(v, (float)(1.0 / length));
    }

    public static VectorFloat<?> sum(List<VectorFloat<?>> vectors) {
        if (vectors.isEmpty()) {
            throw new IllegalArgumentException("Input list cannot be empty");
        }
        return impl.sum(vectors);
    }

    public static float sum(VectorFloat<?> vector) {
        return impl.sum(vector);
    }

    public static void scale(VectorFloat<?> vector, float multiplier) {
        impl.scale(vector, multiplier);
    }

    public static void addInPlace(VectorFloat<?> v1, VectorFloat<?> v2) {
        impl.addInPlace(v1, v2);
    }

    public static void subInPlace(VectorFloat<?> v1, VectorFloat<?> v2) {
        impl.subInPlace(v1, v2);
    }

    public static VectorFloat<?> sub(VectorFloat<?> lhs, VectorFloat<?> rhs) {
        return impl.sub(lhs, rhs);
    }

    public static VectorFloat<?> sub(VectorFloat<?> a, int aOffset, VectorFloat<?> b, int bOffset, int length) {
        return impl.sub(a, aOffset, b, bOffset, length);
    }

    public static float assembleAndSum(VectorFloat<?> data, int dataBase, ByteSequence<?> dataOffsets) {
        return impl.assembleAndSum(data, dataBase, dataOffsets);
    }

    public static void bulkShuffleSimilarity(ByteSequence<?> shuffles, int codebookCount, VectorFloat<?> partials, VectorFloat<?> results, VectorSimilarityFunction vsf) {
        impl.bulkShuffleSimilarity(shuffles, codebookCount, partials, vsf, results);
    }

    public static int hammingDistance(long[] v1, long[] v2) {
        return impl.hammingDistance(v1, v2);
    }

    public static void calculatePartialSums(VectorFloat<?> codebook, int baseOffset, int size, int clusterCount, VectorFloat<?> query, int offset, VectorSimilarityFunction vsf, VectorFloat<?> partialSums) {
        impl.calculatePartialSums(codebook, baseOffset, size, clusterCount, query, offset, vsf, partialSums);
    }

    public static void dotProductMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        impl.dotProductMultiScore(v1, v2, results);
    }

    public static void euclideanMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        impl.squareL2DistanceMultiScore(v1, v2, results);
    }

    public static void cosineMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        impl.cosineMultiScore(v1, v2, results);
    }

    public static float max(VectorFloat<?> v) {
        return impl.max(v);
    }

    public static float min(VectorFloat<?> v) {
        return impl.min(v);
    }

    public static float lvqDotProduct(VectorFloat<?> v, LocallyAdaptiveVectorQuantization.PackedVector quantizedVector, float querySum) {
        return impl.lvqDotProduct(v, quantizedVector, querySum);
    }

    public static float lvqSquareL2Distance(VectorFloat<?> centeredV, LocallyAdaptiveVectorQuantization.PackedVector quantizedVector) {
        return impl.lvqSquareL2Distance(centeredV, quantizedVector);
    }

    public static float lvqCosine(VectorFloat<?> v, LocallyAdaptiveVectorQuantization.PackedVector quantizedVector, VectorFloat<?> centroid) {
        return impl.lvqCosine(v, quantizedVector, centroid);
    }
}

