/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public abstract class NodesIterator
implements PrimitiveIterator.OfInt {
    protected final int size;

    public NodesIterator(int size) {
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public static NodesIterator fromPrimitiveIterator(final PrimitiveIterator.OfInt iterator, int size) {
        return new NodesIterator(size){

            @Override
            public int nextInt() {
                return iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static class ArrayNodesIterator
    extends NodesIterator {
        private final int[] nodes;
        private int cur = 0;

        public ArrayNodesIterator(int[] nodes, int size) {
            super(size);
            assert (nodes != null);
            assert (size <= nodes.length);
            this.nodes = nodes;
        }

        public ArrayNodesIterator(int[] nodes) {
            this(nodes, nodes.length);
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nodes == null) {
                return this.cur++;
            }
            return this.nodes[this.cur++];
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.size;
        }
    }
}

