/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.similarity;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;

public final class SearchScoreProvider {
    private final ScoreFunction scoreFunction;
    private final ScoreFunction.Reranker reranker;

    public SearchScoreProvider(ScoreFunction scoreFunction) {
        this(scoreFunction, null);
    }

    public SearchScoreProvider(ScoreFunction scoreFunction, ScoreFunction.Reranker reranker) {
        assert (scoreFunction != null);
        this.scoreFunction = scoreFunction;
        this.reranker = reranker;
    }

    public ScoreFunction scoreFunction() {
        return this.scoreFunction;
    }

    public ScoreFunction.Reranker reranker() {
        return this.reranker;
    }

    public ScoreFunction.ExactScoreFunction exactScoreFunction() {
        return this.scoreFunction.isExact() ? (ScoreFunction.ExactScoreFunction)this.scoreFunction : this.reranker;
    }

    public static SearchScoreProvider exact(VectorFloat<?> v, VectorSimilarityFunction vsf, RandomAccessVectorValues ravv) {
        ScoreFunction.Reranker sf = ScoreFunction.Reranker.from(v, vsf, ravv);
        return new SearchScoreProvider(sf);
    }
}

