/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.disk.LVQ;
import io.github.jbellis.jvector.graph.disk.LVQPackedVectors;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.pq.LocallyAdaptiveVectorQuantization;
import io.github.jbellis.jvector.util.ExceptionUtils;
import io.github.jbellis.jvector.util.ExplicitThreadLocal;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.Closeable;
import java.io.IOException;

public class LvqVectorValues
implements RandomAccessVectorValues,
Closeable {
    private final int dimension;
    private final OnDiskGraphIndexWriter writer;
    private final ExplicitThreadLocal<LVQPackedVectors> sources;

    public LvqVectorValues(int dimension, LVQ lvq, OnDiskGraphIndexWriter writer) {
        this.dimension = dimension;
        this.writer = writer;
        this.sources = ExplicitThreadLocal.withInitial(() -> new CloseablePackedVectors(lvq.createPackedVectors(writer.getFeatureSource())));
    }

    @Override
    public int size() {
        return this.writer.getMaxOrdinal() + 1;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public VectorFloat<?> getVector(int ordinal) {
        LocallyAdaptiveVectorQuantization.PackedVector packed = this.sources.get().getPackedVector(ordinal);
        return packed.decode();
    }

    @Override
    public boolean isValueShared() {
        return false;
    }

    @Override
    public RandomAccessVectorValues copy() {
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.sources.close();
        }
        catch (Exception e) {
            ExceptionUtils.throwIoException(e);
        }
    }

    private static class CloseablePackedVectors
    implements LVQPackedVectors,
    Closeable {
        private final LVQ.PackedVectors raw;

        public CloseablePackedVectors(LVQ.PackedVectors raw) {
            this.raw = raw;
        }

        @Override
        public LocallyAdaptiveVectorQuantization.PackedVector getPackedVector(int ordinal) {
            return this.raw.getPackedVector(ordinal);
        }

        @Override
        public void close() throws IOException {
            this.raw.source.close();
        }
    }
}

