/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;

public class BufferedRandomAccessWriter
implements Closeable {
    private final RandomAccessFile raf;
    private final TransparentByteArrayOutputStream scratchBytes = new TransparentByteArrayOutputStream(4096);
    private final DataOutputStream scratch = new DataOutputStream(this.scratchBytes);

    public BufferedRandomAccessWriter(Path path) throws FileNotFoundException {
        this.raf = new RandomAccessFile(path.toFile(), "rw");
    }

    public void seek(long position) throws IOException {
        this.raf.seek(position);
    }

    public void writeBuffered(ChunkWriter writer) throws IOException {
        assert (this.scratchBytes.size() == 0);
        writer.write(this.scratch);
        this.raf.write(this.scratchBytes.getArray(), 0, this.scratchBytes.size());
        this.scratchBytes.reset();
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public void writeInt(int i) throws IOException {
        this.raf.writeInt(i);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    private static class TransparentByteArrayOutputStream
    extends ByteArrayOutputStream {
        public TransparentByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getArray() {
            return this.buf;
        }
    }

    @FunctionalInterface
    public static interface ChunkWriter {
        public void write(DataOutput var1) throws IOException;
    }
}

