/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.VectorUtilSupport;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import java.util.Arrays;
import java.util.List;

public final class VectorUtil {
    private static final VectorUtilSupport impl = VectorizationProvider.getInstance().getVectorUtilSupport();

    private VectorUtil() {
    }

    public static float dotProduct(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = impl.dotProduct(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float dotProduct(float[] a, int aoffset, float[] b, int boffset, int length) {
        float r = impl.dotProduct(a, aoffset, b, boffset, length);
        assert (Float.isFinite(r)) : String.format("dotProduct(%s, %s) = %s", Arrays.toString(a), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float cosine(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = impl.cosine(a, b);
        assert (Float.isFinite(r)) : String.format("cosine(%s, %s) = %s", Arrays.toString(a), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float cosine(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return impl.cosine(a, b);
    }

    public static float squareDistance(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = impl.squareDistance(a, b);
        assert (Float.isFinite(r)) : String.format("squareDistance(%s, %s) = %s", Arrays.toString(a), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float squareDistance(float[] a, int aoffset, float[] b, int boffset, int length) {
        float r = impl.squareDistance(a, aoffset, b, boffset, length);
        assert (Float.isFinite(r));
        return r;
    }

    public static int squareDistance(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return impl.squareDistance(a, b);
    }

    public static void l2normalize(float[] v) {
        double squareSum = VectorUtil.dotProduct(v, v);
        if (squareSum == 0.0) {
            throw new IllegalArgumentException("Cannot normalize a zero-length vector");
        }
        double length = Math.sqrt(squareSum);
        VectorUtil.scale(v, (float)(1.0 / length));
    }

    public static int dotProduct(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return impl.dotProduct(a, b);
    }

    public static float dotProductScore(byte[] a, byte[] b) {
        float denom = a.length * 32768;
        return 0.5f + (float)VectorUtil.dotProduct(a, b) / denom;
    }

    public static float[] sum(List<float[]> vectors) {
        if (vectors.isEmpty()) {
            throw new IllegalArgumentException("Input list cannot be empty");
        }
        return impl.sum(vectors);
    }

    public static float sum(float[] vector) {
        return impl.sum(vector);
    }

    public static void scale(float[] vector, float multiplier) {
        impl.scale(vector, multiplier);
    }

    public static void addInPlace(float[] v1, float[] v2) {
        impl.addInPlace(v1, v2);
    }

    public static void subInPlace(float[] v1, float[] v2) {
        impl.subInPlace(v1, v2);
    }

    public static float[] sub(float[] lhs, float[] rhs) {
        return impl.sub(lhs, rhs);
    }

    public static float assembleAndSum(float[] data, int dataBase, byte[] dataOffsets) {
        return impl.assembleAndSum(data, dataBase, dataOffsets);
    }

    public static int hammingDistance(long[] v1, long[] v2) {
        return impl.hammingDistance(v1, v2);
    }
}

