/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.ArrayUtil;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.IntStream;

public class DenseIntMap<T> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile AtomicReferenceArray<T> objects;
    private final AtomicInteger size;

    public DenseIntMap(int initialSize) {
        this.objects = new AtomicReferenceArray(initialSize);
        this.size = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int key, T value) {
        if (value == null) {
            throw new IllegalArgumentException("put() value cannot be null -- use remove() instead");
        }
        this.ensureCapacity(key);
        boolean isInsert = false;
        this.rwl.readLock().lock();
        try {
            boolean bl = isInsert = this.objects.getAndSet(key, value) == null || isInsert;
            if (isInsert) {
                this.size.incrementAndGet();
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int size() {
        return this.size.get();
    }

    public T get(int key) {
        AtomicReferenceArray<T> ref = this.objects;
        if (key >= ref.length()) {
            return null;
        }
        return ref.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int node) {
        if (node < this.objects.length()) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            AtomicReferenceArray<T> oldArray = this.objects;
            if (node >= oldArray.length()) {
                int newSize = ArrayUtil.oversize(node + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                AtomicReferenceArray<T> newArray = new AtomicReferenceArray<T>(newSize);
                for (int i = 0; i < oldArray.length(); ++i) {
                    newArray.set(i, oldArray.get(i));
                }
                this.objects = newArray;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int key) {
        if (key >= this.objects.length()) {
            return null;
        }
        T old = this.objects.get(key);
        if (old == null) {
            return null;
        }
        this.rwl.readLock().lock();
        try {
            if (this.objects.compareAndSet(key, old, null)) {
                this.size.decrementAndGet();
                T t = old;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public Set<Map.Entry<Integer, T>> entrySet() {
        HashSet<Map.Entry<Integer, T>> entries = new HashSet<Map.Entry<Integer, T>>(this.size());
        AtomicReferenceArray<T> ref = this.objects;
        for (int i = 0; i < ref.length(); ++i) {
            T value = ref.get(i);
            if (value == null) continue;
            entries.add(new AbstractMap.SimpleEntry<Integer, T>(i, value));
        }
        return entries;
    }

    public Set<Integer> keySet() {
        HashSet<Integer> keys = new HashSet<Integer>(this.size());
        AtomicReferenceArray<T> ref = this.objects;
        for (int i = 0; i < ref.length(); ++i) {
            T value = ref.get(i);
            if (value == null) continue;
            keys.add(i);
        }
        return keys;
    }

    public NodesIterator getNodesIterator() {
        int minSize = this.size();
        AtomicReferenceArray ref = this.objects;
        PrimitiveIterator.OfInt keysInts = IntStream.range(0, ref.length()).filter(i -> ref.get(i) != null).iterator();
        return NodesIterator.fromPrimitiveIterator(keysInts, minSize);
    }
}

