/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.pq.ProductQuantization;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompressedVectors {
    private final ProductQuantization pq;
    private final List<byte[]> compressedVectors;

    public CompressedVectors(ProductQuantization pq, List<byte[]> compressedVectors) {
        this.pq = pq;
        this.compressedVectors = compressedVectors;
    }

    public void write(DataOutput out) throws IOException {
        this.pq.write(out);
        out.writeInt(this.compressedVectors.size());
        out.writeInt(this.pq.getSubspaceCount());
        for (byte[] v : this.compressedVectors) {
            out.write(v);
        }
    }

    public static CompressedVectors load(RandomAccessReader in, long offset) throws IOException {
        in.seek(offset);
        ProductQuantization pq = ProductQuantization.load(in);
        int size = in.readInt();
        ArrayList<byte[]> compressedVectors = new ArrayList<byte[]>(size);
        int compressedDimension = in.readInt();
        for (int i = 0; i < size; ++i) {
            byte[] vector = new byte[compressedDimension];
            in.readFully(vector);
            compressedVectors.add(vector);
        }
        return new CompressedVectors(pq, compressedVectors);
    }

    public float decodedSimilarity(int ordinal, float[] v, VectorSimilarityFunction similarityFunction) {
        switch (similarityFunction) {
            case DOT_PRODUCT: {
                return (1.0f + this.pq.decodedDotProduct(this.compressedVectors.get(ordinal), v)) / 2.0f;
            }
        }
        float[] decoded = new float[this.pq.getOriginalDimension()];
        this.pq.decode(this.compressedVectors.get(ordinal), decoded);
        return similarityFunction.compare(decoded, v);
    }
}

