/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.GraphCache;
import io.github.jbellis.jvector.disk.OnDiskGraphIndex;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Accountable;
import java.io.IOException;
import java.io.UncheckedIOException;

public class CachingGraphIndex
implements GraphIndex<float[]>,
AutoCloseable,
Accountable {
    private static final int BFS_DISTANCE = 3;
    private final GraphCache cache;
    private final OnDiskGraphIndex<float[]> graph;

    public CachingGraphIndex(OnDiskGraphIndex<float[]> graph) {
        this.graph = graph;
        try {
            this.cache = GraphCache.load(graph, 3);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public NodesIterator getNodes() {
        return this.graph.getNodes();
    }

    @Override
    public GraphIndex.View<float[]> getView() {
        return new CachedView(this.graph.getView());
    }

    @Override
    public int maxEdgesPerNode() {
        return this.graph.maxEdgesPerNode();
    }

    @Override
    public long ramBytesUsed() {
        return this.graph.ramBytesUsed() + this.cache.ramBytesUsed();
    }

    @Override
    public void close() {
        this.graph.close();
    }

    private class CachedView
    implements GraphIndex.View<float[]> {
        private final GraphIndex.View<float[]> view;

        public CachedView(GraphIndex.View<float[]> view) {
            this.view = view;
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            GraphCache.CachedNode cached = CachingGraphIndex.this.cache.getNode(node);
            if (cached != null) {
                return new NodesIterator.ArrayNodesIterator(cached.neighbors, cached.neighbors.length);
            }
            return this.view.getNeighborsIterator(node);
        }

        @Override
        public float[] getVector(int node) {
            GraphCache.CachedNode cached = CachingGraphIndex.this.cache.getNode(node);
            if (cached != null) {
                return cached.vector;
            }
            return this.view.getVector(node);
        }

        @Override
        public int size() {
            return this.view.size();
        }

        @Override
        public int entryNode() {
            return this.view.entryNode();
        }

        @Override
        public int[] getSortedNodes() {
            return GraphIndex.View.super.getSortedNodes();
        }

        @Override
        public int getNeighborCount(int node) {
            return GraphIndex.View.super.getNeighborCount(node);
        }
    }
}

