/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.disk;

import com.github.jbellis.jvector.graph.GraphIndex;
import com.github.jbellis.jvector.graph.NodesIterator;
import com.github.jbellis.jvector.util.Accountable;
import com.github.jbellis.jvector.util.RamUsageEstimator;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GraphCache
implements Accountable {
    public abstract CachedNode getNode(int var1);

    public static GraphCache load(GraphIndex<float[]> graph, int distance) throws IOException {
        if (distance <= 0) {
            return new EmptyGraphCache();
        }
        return new CHMGraphCache(graph, distance);
    }

    @Override
    public abstract long ramBytesUsed();

    private static final class EmptyGraphCache
    extends GraphCache {
        private EmptyGraphCache() {
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }
    }

    private static final class CHMGraphCache
    extends GraphCache {
        private final ConcurrentHashMap<Integer, CachedNode> cache = new ConcurrentHashMap();
        private long ramBytesUsed = 0L;

        public CHMGraphCache(GraphIndex<float[]> graph, int distance) {
            GraphIndex.View<float[]> view = graph.getView();
            this.cacheNeighborsOf(view, view.entryNode(), distance);
        }

        private void cacheNeighborsOf(GraphIndex.View<float[]> view, int ordinal, int distance) {
            NodesIterator it = view.getNeighborsIterator(ordinal);
            int[] neighbors = new int[it.size()];
            int i = 0;
            while (it.hasNext()) {
                neighbors[i++] = it.next();
            }
            CachedNode node = new CachedNode(view.getVector(ordinal), neighbors);
            this.cache.put(ordinal, node);
            this.ramBytesUsed += RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.sizeOf(node.vector) + RamUsageEstimator.sizeOf(node.neighbors);
            if (distance > 0) {
                for (int neighbor : neighbors) {
                    if (this.cache.containsKey(neighbor)) continue;
                    this.cacheNeighborsOf(view, neighbor, distance - 1);
                }
            }
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return this.cache.get(ordinal);
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }

    public static final class CachedNode {
        public final float[] vector;
        public final int[] neighbors;

        public CachedNode(float[] vector, int[] neighbors) {
            this.vector = vector;
            this.neighbors = neighbors;
        }
    }
}

