/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.vector;

import java.util.List;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

final class SimdOps {
    SimdOps() {
    }

    static float sum(float[] vector) {
        FloatVector sum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(vector.length);
        for (int i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])vector, (int)i);
            sum = sum.add((Vector)a);
        }
        float res = sum.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < vector.length; ++i) {
            res += vector[i];
        }
        return res;
    }

    static float[] sum(List<float[]> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            throw new IllegalArgumentException("Input list cannot be null or empty");
        }
        int dimension = vectors.get(0).length;
        float[] sum = new float[dimension];
        for (float[] vector : vectors) {
            SimdOps.addInPlace(sum, vector);
        }
        return sum;
    }

    static void divInPlace(float[] vector, float divisor) {
        int i;
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(vector.length);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])vector, (int)i);
            FloatVector divResult = a.div(divisor);
            divResult.intoArray(vector, i);
        }
        for (i = vectorizedLength; i < vector.length; ++i) {
            vector[i] = vector[i] / divisor;
        }
    }

    static float dot64(float[] v1, int offset1, float[] v2, int offset2) {
        FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_64, (float[])v1, (int)offset1);
        FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_64, (float[])v2, (int)offset2);
        return a.mul((Vector)b).reduceLanes(VectorOperators.ADD);
    }

    static float dot128(float[] v1, int offset1, float[] v2, int offset2) {
        FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_128, (float[])v1, (int)offset1);
        FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_128, (float[])v2, (int)offset2);
        return a.mul((Vector)b).reduceLanes(VectorOperators.ADD);
    }

    static float dot256(float[] v1, int offset1, float[] v2, int offset2) {
        FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_256, (float[])v1, (int)offset1);
        FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_256, (float[])v2, (int)offset2);
        return a.mul((Vector)b).reduceLanes(VectorOperators.ADD);
    }

    static float dotPreferred(float[] v1, int offset1, float[] v2, int offset2) {
        FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v1, (int)offset1);
        FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v2, (int)offset2);
        return a.mul((Vector)b).reduceLanes(VectorOperators.ADD);
    }

    static float dotProduct(float[] v1, float[] v2) {
        return SimdOps.dotProduct(v1, 0, v2, 0, v1.length);
    }

    static float dotProduct(float[] v1, int v1offset, float[] v2, int v2offset, int length) {
        if (length >= FloatVector.SPECIES_PREFERRED.length()) {
            return SimdOps.dotProductPreferred(v1, v1offset, v2, v2offset, length);
        }
        if (length < FloatVector.SPECIES_128.length()) {
            return SimdOps.dotProduct64(v1, v1offset, v2, v2offset, length);
        }
        if (length < FloatVector.SPECIES_256.length()) {
            return SimdOps.dotProduct128(v1, v1offset, v2, v2offset, length);
        }
        return SimdOps.dotProduct256(v1, v1offset, v2, v2offset, length);
    }

    static float dotProduct64(float[] v1, int v1offset, float[] v2, int v2offset, int length) {
        int i;
        if (length == FloatVector.SPECIES_64.length()) {
            return SimdOps.dot64(v1, v1offset, v2, v2offset);
        }
        int vectorizedLength = FloatVector.SPECIES_64.loopBound(length);
        FloatVector sum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_64);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_64.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_64, (float[])v1, (int)(v1offset + i));
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_64, (float[])v2, (int)(v2offset + i));
            sum = sum.add((Vector)a.mul((Vector)b));
        }
        float res = sum.reduceLanes(VectorOperators.ADD);
        while (i < length) {
            res += v1[v1offset + i] * v2[v2offset + i];
            ++i;
        }
        return res;
    }

    static float dotProduct128(float[] v1, int v1offset, float[] v2, int v2offset, int length) {
        int i;
        if (length == FloatVector.SPECIES_128.length()) {
            return SimdOps.dot128(v1, v1offset, v2, v2offset);
        }
        int vectorizedLength = FloatVector.SPECIES_128.loopBound(length);
        FloatVector sum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_128);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_128.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_128, (float[])v1, (int)(v1offset + i));
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_128, (float[])v2, (int)(v2offset + i));
            sum = sum.add((Vector)a.mul((Vector)b));
        }
        float res = sum.reduceLanes(VectorOperators.ADD);
        while (i < length) {
            res += v1[v1offset + i] * v2[v2offset + i];
            ++i;
        }
        return res;
    }

    static float dotProduct256(float[] v1, int v1offset, float[] v2, int v2offset, int length) {
        int i;
        if (length == FloatVector.SPECIES_256.length()) {
            return SimdOps.dot256(v1, v1offset, v2, v2offset);
        }
        int vectorizedLength = FloatVector.SPECIES_256.loopBound(length);
        FloatVector sum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_256);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_256.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_256, (float[])v1, (int)(v1offset + i));
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_256, (float[])v2, (int)(v2offset + i));
            sum = sum.add((Vector)a.mul((Vector)b));
        }
        float res = sum.reduceLanes(VectorOperators.ADD);
        while (i < length) {
            res += v1[v1offset + i] * v2[v2offset + i];
            ++i;
        }
        return res;
    }

    static float dotProductPreferred(float[] v1, int v1offset, float[] v2, int v2offset, int length) {
        int i;
        if (length == FloatVector.SPECIES_PREFERRED.length()) {
            return SimdOps.dotPreferred(v1, v1offset, v2, v2offset);
        }
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(length);
        FloatVector sum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v1, (int)(v1offset + i));
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v2, (int)(v2offset + i));
            sum = sum.add((Vector)a.mul((Vector)b));
        }
        float res = sum.reduceLanes(VectorOperators.ADD);
        while (i < length) {
            res += v1[v1offset + i] * v2[v2offset + i];
            ++i;
        }
        return res;
    }

    static int dotProduct(byte[] v1, byte[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        IntVector sum = IntVector.zero((VectorSpecies)IntVector.SPECIES_256);
        int vectorizedLength = ByteVector.SPECIES_64.loopBound(v1.length);
        for (int i = 0; i < vectorizedLength; i += ByteVector.SPECIES_64.length()) {
            Vector a = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v1, (int)i).castShape(IntVector.SPECIES_256, 0);
            Vector b = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v2, (int)i).castShape(IntVector.SPECIES_256, 0);
            sum = sum.add(a.mul(b));
        }
        int res = sum.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < v1.length; ++i) {
            res += v1[i] * v2[i];
        }
        return res;
    }

    static float cosineSimilarity(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        FloatVector vsum = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        FloatVector vaMagnitude = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        FloatVector vbMagnitude = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(v1.length);
        for (int i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v1, (int)i);
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v2, (int)i);
            vsum = vsum.add((Vector)a.mul((Vector)b));
            vaMagnitude = vaMagnitude.add((Vector)a.mul((Vector)a));
            vbMagnitude = vbMagnitude.add((Vector)b.mul((Vector)b));
        }
        float sum = vsum.reduceLanes(VectorOperators.ADD);
        float aMagnitude = vaMagnitude.reduceLanes(VectorOperators.ADD);
        float bMagnitude = vbMagnitude.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < v1.length; ++i) {
            sum += v1[i] * v2[i];
            aMagnitude += v1[i] * v1[i];
            bMagnitude += v2[i] * v2[i];
        }
        return (float)((double)sum / Math.sqrt(aMagnitude * bMagnitude));
    }

    static float cosineSimilarity(byte[] v1, byte[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        IntVector vsum = IntVector.zero((VectorSpecies)IntVector.SPECIES_256);
        IntVector vaMagnitude = IntVector.zero((VectorSpecies)IntVector.SPECIES_256);
        IntVector vbMagnitude = IntVector.zero((VectorSpecies)IntVector.SPECIES_256);
        int vectorizedLength = ByteVector.SPECIES_64.loopBound(v1.length);
        for (int i = 0; i < vectorizedLength; i += ByteVector.SPECIES_64.length()) {
            Vector a = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v1, (int)i).castShape(IntVector.SPECIES_256, 0);
            Vector b = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v2, (int)i).castShape(IntVector.SPECIES_256, 0);
            vsum = vsum.add(a.mul(b));
            vaMagnitude = vaMagnitude.add(a.mul(a));
            vbMagnitude = vbMagnitude.add(b.mul(b));
        }
        int sum = vsum.reduceLanes(VectorOperators.ADD);
        int aMagnitude = vaMagnitude.reduceLanes(VectorOperators.ADD);
        int bMagnitude = vbMagnitude.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < v1.length; ++i) {
            sum += v1[i] * v2[i];
            aMagnitude += v1[i] * v1[i];
            bMagnitude += v2[i] * v2[i];
        }
        return (float)((double)sum / Math.sqrt(aMagnitude * bMagnitude));
    }

    static float squareDistance(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        FloatVector vdiffSumSquared = FloatVector.zero((VectorSpecies)FloatVector.SPECIES_PREFERRED);
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(v1.length);
        for (int i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v1, (int)i);
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v2, (int)i);
            FloatVector diff = a.sub((Vector)b);
            vdiffSumSquared = vdiffSumSquared.add((Vector)diff.mul((Vector)diff));
        }
        float diffSumSquared = vdiffSumSquared.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < v1.length; ++i) {
            diffSumSquared += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return diffSumSquared;
    }

    static int squareDistance(byte[] v1, byte[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        IntVector vdiffSumSquared = IntVector.zero((VectorSpecies)IntVector.SPECIES_256);
        int vectorizedLength = ByteVector.SPECIES_64.loopBound(v1.length);
        for (int i = 0; i < vectorizedLength; i += ByteVector.SPECIES_64.length()) {
            Vector a = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v1, (int)i).castShape(IntVector.SPECIES_256, 0);
            Vector b = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])v2, (int)i).castShape(IntVector.SPECIES_256, 0);
            Vector diff = a.sub(b);
            vdiffSumSquared = vdiffSumSquared.add(diff.mul(diff));
        }
        int diffSumSquared = vdiffSumSquared.reduceLanes(VectorOperators.ADD);
        for (int i = vectorizedLength; i < v1.length; ++i) {
            diffSumSquared += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return diffSumSquared;
    }

    static void addInPlace(float[] v1, float[] v2) {
        int i;
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        int vectorizedLength = FloatVector.SPECIES_PREFERRED.loopBound(v1.length);
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v1, (int)i);
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])v2, (int)i);
            a.add((Vector)b).intoArray(v1, i);
        }
        for (i = vectorizedLength; i < v1.length; ++i) {
            v1[i] = v1[i] + v2[i];
        }
    }

    static float[] sub(float[] lhs, float[] rhs) {
        int i;
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        float[] result = new float[lhs.length];
        int vectorizedLength = lhs.length / FloatVector.SPECIES_PREFERRED.length() * FloatVector.SPECIES_PREFERRED.length();
        for (i = 0; i < vectorizedLength; i += FloatVector.SPECIES_PREFERRED.length()) {
            FloatVector a = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])lhs, (int)i);
            FloatVector b = FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])rhs, (int)i);
            FloatVector subResult = a.sub((Vector)b);
            subResult.intoArray(result, i);
        }
        for (i = vectorizedLength; i < lhs.length; ++i) {
            result[i] = lhs[i] - rhs[i];
        }
        return result;
    }

    static {
        System.setProperty("jdk.incubator.vector.VECTOR_ACCESS_OOB_CHECK", "0");
    }
}

