/*
 * Decompiled with CFR 0.152.
 */
package io.github.javaezlib.javaez.extensions;

import io.github.javaezlib.javaez.backend.ErrorSystem;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class System {
    public static String whatsMyOS() {
        return java.lang.System.getProperty("os.name");
    }

    public static String whatsMySimplifiedOS() {
        String osName = System.whatsMyOS();
        String osVersion = java.lang.System.getProperty("os.version");
        String osSimplifiedName = null;
        if (osName.toLowerCase().contains("win")) {
            osSimplifiedName = "Windows";
        } else if (osName.toLowerCase().contains("mac")) {
            osSimplifiedName = "macOS";
        } else if (osName.toLowerCase().contains("nix") || osName.toLowerCase().contains("nux") || osName.toLowerCase().contains("aix")) {
            osSimplifiedName = "Linux or UNIX";
        } else if (osName.toLowerCase().contains("sunos")) {
            osSimplifiedName = "Solaris";
        }
        return osSimplifiedName != null ? osSimplifiedName + " Version " + osVersion : osName;
    }

    public static String whoIsUsingThePC() {
        return java.lang.System.getProperty("user.name");
    }

    public static void lockMyPC() {
        if (!System.whatsMyOS().toLowerCase().contains("win")) {
            ErrorSystem.handleError("You are not on Windows! PCs can only be locked on Windows.");
            return;
        }
        try {
            Runtime.getRuntime().exec("rundll32 user32.dll,LockWorkStation");
        }
        catch (IOException e) {
            ErrorSystem.handleError("Error while locking PC");
        }
    }

    public static void openAPath(String path) {
        try {
            Desktop.getDesktop().browse(new URI(path));
        }
        catch (Exception e) {
            ErrorSystem.handleError("Could not open path");
        }
    }

    public static void printAFile(String path) {
        try {
            Desktop.getDesktop().print(new File(path));
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Could not print this file");
        }
    }
}

