/*
 * Decompiled with CFR 0.152.
 */
package io.github.javaezlib.javaez.extensions;

import io.github.javaezlib.javaez.backend.ErrorSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class Files {
    private static BufferedReader currentReader;
    private static BufferedWriter currentWriter;

    public static void openFileForReading(String path) {
        try {
            Files.closeFile();
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.isDirectory()) {
                ErrorSystem.handleError("Error while opening file, it's actually a folder");
                return;
            }
            currentReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while opening file");
        }
    }

    public static void openFileForWriting(String path, boolean append) {
        try {
            Files.closeFile();
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.isDirectory()) {
                ErrorSystem.handleError("Error while opening file, it's actually a folder");
                return;
            }
            currentWriter = new BufferedWriter(new FileWriter(file, append));
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while opening file");
        }
    }

    public static void closeFile() {
        try {
            if (currentReader != null) {
                currentReader.close();
            }
            if (currentWriter != null) {
                currentWriter.close();
            }
            currentReader = null;
            currentWriter = null;
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while closing file");
        }
    }

    public static String readLine() {
        if (currentReader == null) {
            ErrorSystem.handleError("Current reader is null, please open a file for reading!");
            return "";
        }
        try {
            return currentReader.readLine();
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while reading a file");
            return "";
        }
    }

    public static void writeLine(String line) {
        if (currentWriter == null) {
            ErrorSystem.handleError("Current writer is null, please open a file for writing!");
        }
        try {
            currentWriter.write(line + "\n");
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while writing to file!");
        }
    }

    public static void makeFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            ErrorSystem.handleError("This file already exists! Maybe a folder is there with the same name?");
        } else {
            try {
                if (!file.createNewFile()) {
                    ErrorSystem.handleError("We couldn't create the file. Maybe the path was wrong?");
                }
            }
            catch (Exception e) {
                ErrorSystem.handleError("We couldn't create the file. Maybe the path was wrong?");
            }
        }
    }

    public static void makeFolder(String path) {
        File file = new File(path);
        if (file.exists()) {
            ErrorSystem.handleError("This folder already exists! Maybe a file is there with the same name?");
        } else {
            try {
                if (!file.mkdirs()) {
                    ErrorSystem.handleError("We couldn't create the folder. Maybe the path was wrong?");
                }
            }
            catch (Exception e) {
                ErrorSystem.handleError("We couldn't create the folder. Maybe the path was wrong?");
            }
        }
    }

    public static void trashFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            ErrorSystem.handleError("The file/folder doesn't exist.");
        } else {
            try {
                if (!file.delete()) {
                    ErrorSystem.handleError("We couldn't trash the file/folder. Maybe the path was wrong?");
                }
            }
            catch (Exception ex) {
                ErrorSystem.handleError("We couldn't trash the file/folder. Maybe the path was wrong?");
            }
        }
    }
}

