/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.viewpump;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.github.inflationx.viewpump.ViewPumpActivityFactory;
import io.github.inflationx.viewpump.ViewPumpLayoutInflater;

public final class ViewPumpContextWrapper
extends ContextWrapper {
    private ViewPumpLayoutInflater mInflater;

    public static ContextWrapper wrap(@NonNull Context base) {
        return new ViewPumpContextWrapper(base);
    }

    @Nullable
    public static View onActivityCreateView(Activity activity, View parent, View view, String name, Context context, AttributeSet attr) {
        return ViewPumpContextWrapper.get(activity).onActivityCreateView(parent, view, name, context, attr);
    }

    static ViewPumpActivityFactory get(@NonNull Activity activity) {
        if (!(activity.getLayoutInflater() instanceof ViewPumpLayoutInflater)) {
            throw new RuntimeException("This activity does not wrap the Base Context! See ViewPumpContextWrapper.wrap(Context)");
        }
        return (ViewPumpActivityFactory)activity.getLayoutInflater();
    }

    private ViewPumpContextWrapper(Context base) {
        super(base);
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = new ViewPumpLayoutInflater(LayoutInflater.from((Context)this.getBaseContext()), (Context)this, false);
            }
            return this.mInflater;
        }
        return super.getSystemService(name);
    }
}

