/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.viewpump;

import androidx.annotation.NonNull;
import io.github.inflationx.viewpump.InflateRequest;
import io.github.inflationx.viewpump.InflateResult;
import io.github.inflationx.viewpump.Interceptor;
import java.util.List;

class InterceptorChain
implements Interceptor.Chain {
    private final List<Interceptor> interceptors;
    private final int index;
    private final InflateRequest request;

    InterceptorChain(@NonNull List<Interceptor> interceptors, int index, @NonNull InflateRequest request) {
        this.interceptors = interceptors;
        this.index = index;
        this.request = request;
    }

    @Override
    @NonNull
    public InflateRequest request() {
        return this.request;
    }

    @Override
    @NonNull
    public InflateResult proceed(@NonNull InflateRequest request) {
        if (this.index >= this.interceptors.size()) {
            throw new AssertionError((Object)"no interceptors added to the chain");
        }
        InterceptorChain next = new InterceptorChain(this.interceptors, this.index + 1, request);
        Interceptor interceptor = this.interceptors.get(this.index);
        InflateResult result = interceptor.intercept(next);
        if (result == null) {
            throw new NullPointerException("interceptor " + interceptor + " returned null");
        }
        return result;
    }
}

