/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import nl.altindag.log.model.LogMarker;
import org.slf4j.Marker;

public final class MarkerMapper
implements Function<Marker, LogMarker> {
    private static final MarkerMapper INSTANCE = new MarkerMapper();

    private MarkerMapper() {
    }

    @Override
    public LogMarker apply(Marker marker) {
        String name = marker.getName();
        ArrayList<LogMarker> innerLogMarkers = new ArrayList<LogMarker>();
        if (marker.hasReferences()) {
            Iterator iterator = marker.iterator();
            while (iterator.hasNext()) {
                LogMarker innerLogMarker = this.apply((Marker)iterator.next());
                innerLogMarkers.add(innerLogMarker);
            }
        }
        return new LogMarker(name, Collections.unmodifiableList(innerLogMarkers));
    }

    public static MarkerMapper getInstance() {
        return INSTANCE;
    }
}

