/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.util;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.regex.Pattern;
import nl.altindag.log.exception.LogCaptorException;
import nl.altindag.log.util.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLogger;

public final class LogbackUtils {
    private static final int DEFAULT_POLL_COUNTER_LIMIT = 10;
    private static final int DEFAULT_POLL_DELAY_MILLISECONDS = 100;
    private static final Pattern IS_NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final BiFunction<String, Integer, Integer> INT_SYSTEM_PROPERTY_PROVIDER = (propertyName, defaultValue) -> Optional.ofNullable(System.getProperty(propertyName)).map(String::trim).filter(value -> !value.isEmpty()).filter(value -> IS_NUMBER_PATTERN.matcher((CharSequence)value).matches()).map(Integer::parseInt).orElse((Integer)defaultValue);
    private static final IntSupplier POLL_COUNTER_LIMIT = () -> INT_SYSTEM_PROPERTY_PROVIDER.apply("logcaptor.poll-counter-limit", 10);
    private static final IntSupplier POLL_DELAY_MILLISECONDS = () -> INT_SYSTEM_PROPERTY_PROVIDER.apply("logcaptor.poll-delay-milliseconds", 100);

    private LogbackUtils() {
    }

    public static ch.qos.logback.classic.Logger getLogger(String loggerName) {
        Logger slf4jLogger = LogbackUtils.getSlf4jLogger(loggerName);
        ValidationUtils.requireLoggerOfType(slf4jLogger, ch.qos.logback.classic.Logger.class);
        return (ch.qos.logback.classic.Logger)slf4jLogger;
    }

    private static Logger getSlf4jLogger(String loggerName) {
        int retryCounter = 0;
        Logger slf4jLogger = LoggerFactory.getLogger((String)loggerName);
        if (!(slf4jLogger instanceof SubstituteLogger)) {
            return slf4jLogger;
        }
        int pollCounterLimit = POLL_COUNTER_LIMIT.getAsInt();
        int pollDelayMilliseconds = POLL_DELAY_MILLISECONDS.getAsInt();
        while (slf4jLogger instanceof SubstituteLogger && retryCounter++ < pollCounterLimit) {
            try {
                TimeUnit.MILLISECONDS.sleep(pollDelayMilliseconds);
                slf4jLogger = LoggerFactory.getLogger((String)loggerName);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LogCaptorException(e);
            }
        }
        return slf4jLogger;
    }
}

