package com.g42cloud.sdk.vpc.v2.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.g42cloud.sdk.core.SdkResponse;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * Response Object
 */
public class ShowNetworkIpAvailabilitiesResponse extends SdkResponse {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "network_ip_availability")

    private NetworkIpAvailability networkIpAvailability;

    public ShowNetworkIpAvailabilitiesResponse withNetworkIpAvailability(NetworkIpAvailability networkIpAvailability) {
        this.networkIpAvailability = networkIpAvailability;
        return this;
    }

    public ShowNetworkIpAvailabilitiesResponse withNetworkIpAvailability(
        Consumer<NetworkIpAvailability> networkIpAvailabilitySetter) {
        if (this.networkIpAvailability == null) {
            this.networkIpAvailability = new NetworkIpAvailability();
            networkIpAvailabilitySetter.accept(this.networkIpAvailability);
        }

        return this;
    }

    public NetworkIpAvailability getNetworkIpAvailability() {
        return networkIpAvailability;
    }

    public void setNetworkIpAvailability(NetworkIpAvailability networkIpAvailability) {
        this.networkIpAvailability = networkIpAvailability;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        ShowNetworkIpAvailabilitiesResponse that = (ShowNetworkIpAvailabilitiesResponse) obj;
        return Objects.equals(this.networkIpAvailability, that.networkIpAvailability);
    }

    @Override
    public int hashCode() {
        return Objects.hash(networkIpAvailability);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShowNetworkIpAvailabilitiesResponse {\n");
        sb.append("    networkIpAvailability: ").append(toIndentedString(networkIpAvailability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
