/*
 * Decompiled with CFR 0.152.
 */
package com.face.libyuv;

import android.graphics.Rect;
import android.media.Image;
import androidx.annotation.NonNull;
import com.face.libyuv.FourCC;
import java.nio.ByteBuffer;

public final class LibYuv {
    private LibYuv() {
        throw new AssertionError();
    }

    @NonNull
    public static byte[] imageToI420(Image image, int degrees) {
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer yBuffer = planes[0].getBuffer();
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int yStride = planes[0].getRowStride();
        int uStride = planes[1].getRowStride();
        int vStride = planes[2].getRowStride();
        int pixelStride = planes[2].getPixelStride();
        int width = image.getWidth();
        int height = image.getHeight();
        return LibYuv.yuvToI420(yBuffer, uBuffer, vBuffer, yStride, uStride, vStride, pixelStride, width, height, degrees);
    }

    @NonNull
    public static byte[] nv21ToI420(@NonNull byte[] nv21Data, int width, int height) {
        byte[] dstData = new byte[width * height * 3 >> 1];
        LibYuv.NV21ToI420(nv21Data, width, height, dstData);
        return dstData;
    }

    @NonNull
    public static byte[] i420ToNv21(@NonNull byte[] i420Data, int width, int height) {
        byte[] dstData = new byte[width * height * 3 >> 1];
        LibYuv.I420ToNV21(i420Data, width, height, dstData);
        return dstData;
    }

    @NonNull
    public static byte[] rotate(@NonNull byte[] srcData, int width, int height, int degrees, @NonNull FourCC fourcc) {
        if (fourcc == FourCC.FOURCC_I420) {
            return LibYuv.i420Rotate(srcData, width, height, degrees);
        }
        byte[] i420Data = LibYuv.convertToI420(srcData, width, height, degrees, fourcc);
        int w = width;
        int h = height;
        if (degrees == 90 || degrees == 270) {
            w = height;
            h = width;
        }
        return LibYuv.convertFromI420(i420Data, w, h, srcData.length, fourcc);
    }

    @NonNull
    public static byte[] scale(@NonNull byte[] srcData, int width, int height, int dstWidth, int dstHeight, @NonNull FourCC fourcc, int filterMode) {
        int dstSize = fourcc.getTotalBppSize(dstWidth, dstHeight);
        return LibYuv.scale(srcData, width, height, dstWidth, dstHeight, dstSize, fourcc, filterMode);
    }

    @NonNull
    public static byte[] scale(@NonNull byte[] srcData, int width, int height, int dstWidth, int dstHeight, int dstSize, @NonNull FourCC fourcc, int filterMode) {
        if (fourcc == FourCC.FOURCC_I420) {
            return LibYuv.i420Scale(srcData, width, height, dstWidth, dstHeight, filterMode);
        }
        byte[] i420Data = LibYuv.convertToI420(srcData, width, height, fourcc);
        byte[] dstI420Data = LibYuv.i420Scale(i420Data, width, height, dstWidth, dstHeight, filterMode);
        return LibYuv.convertFromI420(dstI420Data, dstWidth, dstHeight, dstSize, fourcc);
    }

    @NonNull
    public static byte[] crop(@NonNull byte[] srcData, int width, int height, @NonNull Rect cropRect, @NonNull FourCC fourcc) {
        return LibYuv.crop(srcData, width, height, cropRect.left, cropRect.top, cropRect.width(), cropRect.height(), fourcc);
    }

    @NonNull
    public static byte[] crop(@NonNull byte[] srcData, int width, int height, int cropX, int cropY, int cropWidth, int cropHeight, @NonNull FourCC fourcc) {
        int dstSize = fourcc.getTotalBppSize(cropWidth, cropHeight);
        return LibYuv.crop(srcData, width, height, cropX, cropY, cropWidth, cropHeight, dstSize, fourcc);
    }

    @NonNull
    public static byte[] crop(@NonNull byte[] srcData, int width, int height, int cropX, int cropY, int cropWidth, int cropHeight, int dstSize, @NonNull FourCC fourcc) {
        if (fourcc == FourCC.FOURCC_I420) {
            return LibYuv.i420Crop(srcData, width, height, cropX, cropY, cropWidth, cropHeight);
        }
        byte[] i420Data = LibYuv.convertToI420(srcData, width, height, cropX, cropY, cropWidth, cropHeight, 0, fourcc);
        return LibYuv.convertFromI420(i420Data, cropWidth, cropHeight, dstSize, fourcc);
    }

    @NonNull
    public static byte[] mirror(@NonNull byte[] srcData, int width, int height, @NonNull FourCC fourcc) {
        if (fourcc == FourCC.FOURCC_I420) {
            return LibYuv.i420Mirror(srcData, width, height);
        }
        byte[] i420Data = LibYuv.convertToI420(srcData, width, height, fourcc);
        byte[] dstI420Data = LibYuv.i420Mirror(i420Data, width, height);
        return LibYuv.convertFromI420(dstI420Data, width, height, srcData.length, fourcc);
    }

    @NonNull
    public static byte[] convertFromI420(@NonNull byte[] i420Data, int width, int height, @NonNull FourCC fourcc) {
        int dstSize = fourcc.getTotalBppSize(width, height);
        return LibYuv.convertFromI420(i420Data, width, height, dstSize, fourcc);
    }

    @NonNull
    public static byte[] convertFromI420(@NonNull byte[] i420Data, int width, int height, int dstSize, @NonNull FourCC fourcc) {
        byte[] dstData = new byte[dstSize];
        LibYuv.ConvertFromI420(i420Data, width, height, dstData, 0, fourcc.getCode());
        return dstData;
    }

    @NonNull
    public static byte[] convertToI420(@NonNull byte[] srcData, int width, int height, @NonNull FourCC fourcc) {
        return LibYuv.convertToI420(srcData, width, height, 0, fourcc);
    }

    @NonNull
    public static byte[] convertToI420(@NonNull byte[] srcData, int width, int height, int degrees, @NonNull FourCC fourcc) {
        return LibYuv.convertToI420(srcData, width, height, 0, 0, width, height, degrees, fourcc);
    }

    @NonNull
    public static byte[] convertToI420(@NonNull byte[] srcData, int width, int height, @NonNull Rect cropRect, int degrees, @NonNull FourCC fourcc) {
        return LibYuv.convertToI420(srcData, width, height, cropRect.left, cropRect.top, cropRect.width(), cropRect.height(), degrees, fourcc);
    }

    @NonNull
    public static byte[] convertToI420(@NonNull byte[] srcData, int width, int height, int cropX, int cropY, int cropWidth, int cropHeight, int degrees, @NonNull FourCC fourcc) {
        byte[] dstI420Data = new byte[cropWidth * cropHeight * 3 >> 1];
        LibYuv.ConvertToI420(srcData, srcData.length, width, height, dstI420Data, cropX, cropY, cropWidth, cropHeight, degrees, fourcc.getCode());
        return dstI420Data;
    }

    @NonNull
    public static byte[] i420Rotate(@NonNull byte[] srcI420Data, int width, int height, int degrees) {
        byte[] dstData = new byte[srcI420Data.length];
        LibYuv.I420Rotate(srcI420Data, width, height, dstData, degrees);
        return dstData;
    }

    @NonNull
    public static byte[] i420Mirror(@NonNull byte[] srcI420Data, int width, int height) {
        byte[] dstData = new byte[srcI420Data.length];
        LibYuv.I420Mirror(srcI420Data, width, height, dstData);
        return dstData;
    }

    @NonNull
    public static byte[] i420Scale(@NonNull byte[] srcI420Data, int width, int height, int dstWidth, int dstHeight, int filterMode) {
        byte[] dstData = new byte[dstWidth * dstHeight * 3 >> 1];
        LibYuv.I420Scale(srcI420Data, width, height, dstData, dstWidth, dstHeight, filterMode);
        return dstData;
    }

    @NonNull
    public static byte[] i420Crop(@NonNull byte[] srcI420Data, int width, int height, int cropX, int cropY, int cropWidth, int cropHeight) {
        byte[] dstData = new byte[cropWidth * cropHeight * 3 >> 1];
        LibYuv.I420Crop(srcI420Data, width, height, dstData, cropX, cropY, cropWidth, cropHeight);
        return dstData;
    }

    @NonNull
    public static byte[] yuvToI420(ByteBuffer srcYData, ByteBuffer srcUData, ByteBuffer srcVData, int yStride, int uStride, int vStride, int uvPixelStride, int width, int height, int degrees) {
        byte[] dstI420Data = new byte[width * height * 3 >> 1];
        LibYuv.YUVToI420(srcYData, srcUData, srcVData, yStride, uStride, vStride, uvPixelStride, width, height, dstI420Data, degrees);
        return dstI420Data;
    }

    static native void YUVToI420(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9, int var10);

    static native void NV21ToI420(byte[] var0, int var1, int var2, byte[] var3);

    static native void I420ToNV21(byte[] var0, int var1, int var2, byte[] var3);

    static native void ConvertFromI420(byte[] var0, int var1, int var2, byte[] var3, int var4, long var5);

    static native void ConvertToI420(byte[] var0, int var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, int var8, int var9, long var10);

    static native void I420Rotate(byte[] var0, int var1, int var2, byte[] var3, int var4);

    static native void I420Scale(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6);

    static native void I420Crop(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, int var7);

    static native void I420Mirror(byte[] var0, int var1, int var2, byte[] var3);

    static {
        System.loadLibrary("yuvFaceAI");
    }
}

