/*
 * Decompiled with CFR 0.152.
 */
package com.face.libyuv;

import androidx.annotation.NonNull;

public enum FourCC {
    FOURCC_YUY2("YUY2"),
    FOURCC_UYVY("UYVY"),
    FOURCC_RGBP("RGBP"),
    FOURCC_RGBO("RGBO"),
    FOURCC_R444("R444"),
    FOURCC_24BG("24BG"),
    FOURCC_RAW("RAW "),
    FOURCC_ARGB("ARGB"),
    FOURCC_BGRA("BGRA"),
    FOURCC_ABGR("ABGR"),
    FOURCC_RGBA("RGBA"),
    FOURCC_AR30("AR30"),
    FOURCC_I400("I400"),
    FOURCC_NV12("NV12"),
    FOURCC_NV21("NV21"),
    FOURCC_I420("I420"),
    FOURCC_YV12("YV12"),
    FOURCC_I422("I422"),
    FOURCC_YV16("YV16"),
    FOURCC_I444("I444"),
    FOURCC_YV24("YV24");

    private final String format;
    private final long code;

    private FourCC(String format) {
        this.format = format;
        this.code = this.obtainFourccCode(format);
    }

    private long obtainFourccCode(@NonNull String format) {
        char[] chars = format.toCharArray();
        return (long)(chars[0] | chars[1] << 8) | (long)chars[2] << 16 | (long)chars[3] << 24;
    }

    @NonNull
    public String toString() {
        return this.format;
    }

    long getCode() {
        return this.code;
    }

    int getTotalBppSize(int width, int height) {
        return switch (this) {
            case FOURCC_YUY2, FOURCC_UYVY, FOURCC_I422, FOURCC_RGBP, FOURCC_RGBO, FOURCC_R444, FOURCC_YV16 -> width * height << 1;
            case FOURCC_24BG, FOURCC_RAW, FOURCC_YV24 -> width * height * 3;
            case FOURCC_ARGB, FOURCC_BGRA, FOURCC_ABGR, FOURCC_RGBA, FOURCC_I444, FOURCC_AR30 -> width * height << 2;
            case FOURCC_I400 -> width * height;
            case FOURCC_NV12, FOURCC_NV21, FOURCC_I420, FOURCC_YV12 -> width * height * 3 >> 1;
            default -> throw new IllegalArgumentException();
        };
    }
}

