/*
 * Decompiled with CFR 0.152.
 */
package com.elyeproj.loaderviewlibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.elyeproj.loaderviewlibrary.LoaderController;
import com.elyeproj.loaderviewlibrary.LoaderView;
import com.elyeproj.loaderviewlibrary.R;

public class LoaderImageView
extends AppCompatImageView
implements LoaderView {
    private LoaderController loaderController;
    private int defaultColorResource;

    public LoaderImageView(Context context) {
        super(context);
        this.init(null);
    }

    public LoaderImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LoaderImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.loaderController = new LoaderController(this);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.loader_view, 0, 0);
        this.loaderController.setUseGradient(typedArray.getBoolean(R.styleable.loader_view_use_gradient, false));
        this.loaderController.setCorners(typedArray.getInt(R.styleable.loader_view_corners, 0));
        this.defaultColorResource = typedArray.getColor(R.styleable.loader_view_custom_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_color));
        typedArray.recycle();
    }

    public void resetLoader() {
        if (this.getDrawable() != null) {
            super.setImageDrawable(null);
            this.loaderController.startLoading();
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.loaderController.onSizeChanged();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.loaderController.onDraw(canvas);
    }

    @Override
    public void setRectColor(Paint rectPaint) {
        rectPaint.setColor(this.defaultColorResource);
    }

    @Override
    public boolean valueSet() {
        return this.getDrawable() != null;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        if (this.loaderController != null) {
            this.loaderController.stopLoading();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        if (this.loaderController != null) {
            this.loaderController.stopLoading();
        }
    }

    public void setImageIcon(Icon icon) {
        super.setImageIcon(icon);
        if (this.loaderController != null) {
            this.loaderController.stopLoading();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (this.loaderController != null) {
            this.loaderController.stopLoading();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.loaderController.removeAnimatorUpdateListener();
    }
}

