/*
 * Decompiled with CFR 0.152.
 */
package com.elyeproj.loaderviewlibrary;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.view.animation.LinearInterpolator;
import com.elyeproj.loaderviewlibrary.LoaderConstant;
import com.elyeproj.loaderviewlibrary.LoaderView;

class LoaderController
implements ValueAnimator.AnimatorUpdateListener {
    private LoaderView loaderView;
    private Paint rectPaint;
    private LinearGradient linearGradient;
    private float progress;
    private ValueAnimator valueAnimator;
    private float widthWeight = 1.0f;
    private float heightWeight = 1.0f;
    private boolean useGradient = false;
    private int corners = 0;
    private static final int MAX_COLOR_CONSTANT_VALUE = 255;
    private static final int ANIMATION_CYCLE_DURATION = 750;

    public LoaderController(LoaderView view) {
        this.loaderView = view;
        this.init();
    }

    private void init() {
        this.rectPaint = new Paint(3);
        this.loaderView.setRectColor(this.rectPaint);
        this.setValueAnimator(0.5f, 1.0f, -1);
    }

    public void onDraw(Canvas canvas) {
        this.onDraw(canvas, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void onDraw(Canvas canvas, float left_pad, float top_pad, float right_pad, float bottom_pad) {
        float margin_height = (float)canvas.getHeight() * (1.0f - this.heightWeight) / 2.0f;
        this.rectPaint.setAlpha((int)(this.progress * 255.0f));
        if (this.useGradient) {
            this.prepareGradient((float)canvas.getWidth() * this.widthWeight);
        }
        canvas.drawRoundRect(new RectF(0.0f + left_pad, margin_height + top_pad, (float)canvas.getWidth() * this.widthWeight - right_pad, (float)canvas.getHeight() - margin_height - bottom_pad), (float)this.corners, (float)this.corners, this.rectPaint);
    }

    public void onSizeChanged() {
        this.linearGradient = null;
        this.startLoading();
    }

    private void prepareGradient(float width) {
        if (this.linearGradient == null) {
            this.linearGradient = new LinearGradient(0.0f, 0.0f, width, 0.0f, this.rectPaint.getColor(), LoaderConstant.COLOR_DEFAULT_GRADIENT, Shader.TileMode.MIRROR);
        }
        this.rectPaint.setShader((Shader)this.linearGradient);
    }

    public void startLoading() {
        if (this.valueAnimator != null && !this.loaderView.valueSet()) {
            this.valueAnimator.cancel();
            this.init();
            this.valueAnimator.start();
        }
    }

    public void setHeightWeight(float heightWeight) {
        this.heightWeight = this.validateWeight(heightWeight);
    }

    public void setWidthWeight(float widthWeight) {
        this.widthWeight = this.validateWeight(widthWeight);
    }

    public void setUseGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    public void setCorners(int corners) {
        this.corners = corners;
    }

    private float validateWeight(float weight) {
        if (weight > 1.0f) {
            return 1.0f;
        }
        if (weight < 0.0f) {
            return 0.0f;
        }
        return weight;
    }

    public void stopLoading() {
        if (this.valueAnimator != null) {
            this.valueAnimator.cancel();
            this.setValueAnimator(this.progress, 0.0f, 0);
            this.valueAnimator.start();
        }
    }

    private void setValueAnimator(float begin, float end, int repeatCount) {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{begin, end});
        this.valueAnimator.setRepeatCount(repeatCount);
        this.valueAnimator.setDuration(750L);
        this.valueAnimator.setRepeatMode(2);
        this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        this.progress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
        this.loaderView.invalidate();
    }

    public void removeAnimatorUpdateListener() {
        if (this.valueAnimator != null) {
            this.valueAnimator.removeUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.valueAnimator.cancel();
        }
        this.progress = 0.0f;
    }
}

