/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.videoview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.VideoView;
import com.didichuxing.doraemonkit.util.UIUtils;

public class CustomVideoView
extends VideoView
implements View.OnTouchListener {
    private float lastX;
    private float lastY;
    private int thresold = 30;
    private Context mContext;
    private StateListener mStateListener;

    public void setStateListener(StateListener stateListener) {
        this.mStateListener = stateListener;
    }

    public CustomVideoView(Context context) {
        this(context, null);
    }

    public CustomVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setOnTouchListener(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = CustomVideoView.getDefaultSize((int)1920, (int)widthMeasureSpec);
        int height = CustomVideoView.getDefaultSize((int)1080, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.lastX = event.getX();
                this.lastY = event.getY();
                break;
            }
            case 2: {
                float detlaX = event.getX() - this.lastX;
                float detlaY = event.getY() - this.lastY;
                if (Math.abs(detlaX) < (float)this.thresold && Math.abs(detlaY) > (float)this.thresold) {
                    if (event.getX() < (float)(UIUtils.getWidthPixels() / 2)) {
                        this.mStateListener.changeBrightness(detlaY);
                    } else {
                        this.mStateListener.changeVolumn(detlaY);
                    }
                }
                this.lastX = event.getX();
                this.lastY = event.getY();
                break;
            }
            case 1: {
                this.mStateListener.hideHint();
            }
        }
        return true;
    }

    public static interface StateListener {
        public void changeVolumn(float var1);

        public void changeBrightness(float var1);

        public void hideHint();
    }
}

