/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.widget.Scroller;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableInfo;
import com.didichuxing.doraemonkit.widget.tableview.intface.ITouch;
import com.didichuxing.doraemonkit.widget.tableview.listener.Observable;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnTableChangeListener;
import com.didichuxing.doraemonkit.widget.tableview.listener.TableClickObserver;
import java.util.List;

public class MatrixHelper
extends Observable<TableClickObserver>
implements ITouch,
ScaleGestureDetector.OnScaleGestureListener {
    private float maxZoom = 5.0f;
    private float minZoom;
    private float zoom = this.minZoom = 1.0f;
    private int translateX;
    private int translateY;
    private ScaleGestureDetector mScaleGestureDetector;
    private GestureDetector mGestureDetector;
    private boolean isCanZoom = false;
    private boolean isScale;
    private Rect originalRect;
    private Rect zoomRect;
    private float mDownX;
    private float mDownY;
    private int pointMode;
    private Scroller scroller;
    private int mMinimumVelocity;
    private boolean isFling;
    private OnTableChangeListener listener;
    private float flingRate = 1.0f;
    private Rect scaleRect = new Rect();
    private boolean isZooming;
    private boolean isAutoFling = false;
    private OnInterceptListener onInterceptListener;
    int touchSlop;
    private int tempTranslateX;
    private int tempTranslateY;
    private float tempZoom = this.minZoom;
    private boolean isScaleMax;
    private boolean isScaleMin;
    private Point startPoint = new Point(0, 0);
    private Point endPoint = new Point();
    private TimeInterpolator interpolator = new DecelerateInterpolator();
    private TypeEvaluator evaluator = new TypeEvaluator(){
        private Point point = new Point();

        public Object evaluate(float fraction, Object startValue, Object endValue) {
            Point startPoint = (Point)startValue;
            Point endPoint = (Point)endValue;
            int x = (int)((float)startPoint.x + fraction * (float)(endPoint.x - startPoint.x));
            int y = (int)((float)startPoint.y + fraction * (float)(endPoint.y - startPoint.y));
            this.point.set(x, y);
            return this.point;
        }
    };
    private AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            MatrixHelper.this.isAutoFling = true;
        }

        public void onAnimationCancel(Animator animation) {
            MatrixHelper.this.isAutoFling = false;
        }

        public void onAnimationEnd(Animator animation) {
            MatrixHelper.this.isAutoFling = false;
        }
    };

    public MatrixHelper(Context context) {
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new OnTableGestureListener());
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.scroller = new Scroller(context);
        this.zoomRect = new Rect();
        this.originalRect = new Rect();
    }

    @Override
    public boolean handlerTouchEvent(MotionEvent event) {
        if (this.isCanZoom) {
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    @Override
    public void onDisallowInterceptEvent(View view, MotionEvent event) {
        ViewParent parent = view.getParent();
        if (this.zoomRect == null || this.originalRect == null) {
            parent.requestDisallowInterceptTouchEvent(false);
            return;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.pointMode = 1;
                this.mDownX = event.getX();
                this.mDownY = event.getY();
                if (this.originalRect.contains((int)this.mDownX, (int)this.mDownY)) {
                    parent.requestDisallowInterceptTouchEvent(true);
                    break;
                }
                parent.requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 5: {
                ++this.pointMode;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                if (this.pointMode > 1) {
                    parent.requestDisallowInterceptTouchEvent(true);
                    return;
                }
                float disX = event.getX() - this.mDownX;
                float disY = event.getY() - this.mDownY;
                boolean isDisallowIntercept = true;
                if (Math.abs(disX) > Math.abs(disY)) {
                    if (disX > 0.0f && this.toRectLeft() || disX < 0.0f && this.toRectRight()) {
                        isDisallowIntercept = false;
                    }
                } else if (disY > 0.0f && this.toRectTop() || disY < 0.0f && this.toRectBottom()) {
                    isDisallowIntercept = false;
                }
                parent.requestDisallowInterceptTouchEvent(isDisallowIntercept);
                break;
            }
            case 6: {
                --this.pointMode;
                break;
            }
            case 1: 
            case 3: {
                this.pointMode = 0;
                parent.requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    private boolean toRectLeft() {
        return this.translateX <= 0;
    }

    private boolean toRectRight() {
        return this.translateX >= this.zoomRect.width() - this.originalRect.width();
    }

    private boolean toRectBottom() {
        int height = this.zoomRect.height() - this.originalRect.height();
        return this.translateY >= height;
    }

    private boolean toRectTop() {
        return this.translateY <= 0;
    }

    private void notifyViewChanged() {
        if (this.listener != null) {
            this.listener.onTableChanged(this.zoom, this.translateX, this.translateY);
        }
    }

    @Override
    public void notifyObservers(List<TableClickObserver> observers) {
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.tempZoom = this.zoom;
        this.isZooming = true;
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float oldZoom = this.zoom;
        boolean isScaleEnd = false;
        float scale = detector.getScaleFactor();
        if (scale > 1.0f && this.isScaleMax) {
            this.isScaleMin = false;
            return true;
        }
        if (scale < 1.0f && this.isScaleMin) {
            this.isScaleMax = false;
            return true;
        }
        this.zoom = this.tempZoom * scale;
        if (this.zoom >= this.maxZoom) {
            this.isScaleMax = true;
            this.zoom = this.maxZoom;
            isScaleEnd = true;
        } else if (this.zoom <= this.minZoom) {
            this.isScaleMin = true;
            this.zoom = this.minZoom;
            isScaleEnd = true;
        } else {
            this.isScaleMin = false;
            this.isScaleMax = false;
        }
        float factor = this.zoom / oldZoom;
        this.resetTranslate(factor);
        this.notifyViewChanged();
        return isScaleEnd;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.isZooming = false;
    }

    private void startFilingAnim(boolean doubleWay) {
        int scrollX = Math.abs(this.scroller.getFinalX());
        int scrollY = Math.abs(this.scroller.getFinalY());
        if (doubleWay) {
            this.endPoint.set((int)((float)this.scroller.getFinalX() * this.flingRate), (int)((float)this.scroller.getFinalY() * this.flingRate));
        } else if (scrollX > scrollY) {
            this.endPoint.set((int)((float)this.scroller.getFinalX() * this.flingRate), 0);
        } else {
            this.endPoint.set(0, (int)((float)this.scroller.getFinalY() * this.flingRate));
        }
        ValueAnimator valueAnimator = ValueAnimator.ofObject((TypeEvaluator)this.evaluator, (Object[])new Object[]{this.startPoint, this.endPoint});
        valueAnimator.setInterpolator(this.interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (MatrixHelper.this.isFling) {
                    Point point = (Point)animation.getAnimatedValue();
                    MatrixHelper.this.translateX = MatrixHelper.this.tempTranslateX - point.x;
                    MatrixHelper.this.translateY = MatrixHelper.this.tempTranslateY - point.y;
                    MatrixHelper.this.notifyViewChanged();
                } else {
                    animation.cancel();
                }
            }
        });
        int duration = (int)((float)Math.max(scrollX, scrollY) * this.flingRate) / 2;
        valueAnimator.setDuration(duration > 300 ? 300L : (long)duration);
        valueAnimator.start();
    }

    private void resetTranslate(float factor) {
        this.translateX = (int)((float)this.translateX * factor);
        this.translateY = (int)((float)this.translateY * factor);
    }

    public Rect getZoomProviderRect(Rect showRect, Rect providerRect, TableInfo tableInfo) {
        this.originalRect.set(showRect);
        int showWidth = showRect.width();
        int showHeight = showRect.height();
        int offsetX = (int)((float)showWidth * (this.zoom - 1.0f)) / 2;
        int offsetY = (int)((float)showHeight * (this.zoom - 1.0f)) / 2;
        if (!this.isAutoFling) {
            int oldw = providerRect.width();
            int oldh = providerRect.height();
            int newWidth = (int)((float)oldw * this.zoom);
            int newHeight = (int)((float)oldh * this.zoom);
            if (this.zoom > 1.0f) {
                newWidth -= (int)((float)tableInfo.getyAxisWidth() * (this.zoom - 1.0f));
                newHeight -= (int)((float)tableInfo.getTopHeight() * (this.zoom - 1.0f));
            }
            if (tableInfo.getTitleDirection() == 1 || tableInfo.getTitleDirection() == 3) {
                newHeight -= (int)((float)tableInfo.getTableTitleSize() * (this.zoom - 1.0f));
            } else {
                newWidth -= (int)((float)tableInfo.getTableTitleSize() * (this.zoom - 1.0f));
            }
            int minTranslateX = -offsetX;
            int maxTranslateX = newWidth - showWidth - offsetX;
            int minTranslateY = -offsetY;
            int maxTranslateY = newHeight - showHeight - offsetY;
            boolean isFullShowX = false;
            boolean isFullShowY = false;
            if (maxTranslateX > minTranslateX) {
                if (this.translateX < minTranslateX) {
                    this.translateX = minTranslateX;
                } else if (this.translateX > maxTranslateX) {
                    this.translateX = maxTranslateX;
                }
            } else {
                isFullShowX = true;
            }
            if (maxTranslateY > minTranslateY) {
                if (this.translateY < minTranslateY) {
                    this.translateY = minTranslateY;
                } else if (this.translateY > maxTranslateY) {
                    this.translateY = maxTranslateY;
                }
            } else {
                isFullShowY = true;
            }
            this.scaleRect.left = providerRect.left - offsetX - this.translateX + showRect.left;
            this.scaleRect.top = providerRect.top - offsetY - this.translateY + showRect.top;
            if (isFullShowX) {
                if (this.isZooming) {
                    this.scaleRect.left = this.scaleRect.left < showRect.left ? showRect.left : this.scaleRect.left;
                    this.scaleRect.left = this.scaleRect.left > showRect.right - newWidth ? showRect.right - newWidth : this.scaleRect.left;
                } else {
                    this.scaleRect.left = showRect.left;
                    this.translateX = minTranslateX;
                }
            }
            if (isFullShowY) {
                if (this.isZooming) {
                    this.scaleRect.top = this.scaleRect.top < showRect.top ? showRect.top : this.scaleRect.top;
                    this.scaleRect.top = this.scaleRect.top > showRect.bottom - newHeight ? showRect.bottom - newHeight : this.scaleRect.top;
                } else {
                    this.scaleRect.top = showRect.top;
                    this.translateY = minTranslateY;
                }
            }
            this.scaleRect.right = this.scaleRect.left + newWidth;
            this.scaleRect.bottom = this.scaleRect.top + newHeight;
            this.zoomRect.set(this.scaleRect);
        } else {
            this.translateX = providerRect.left - this.zoomRect.left - offsetX;
            this.translateY = providerRect.top - this.zoomRect.top - offsetY;
            this.scaleRect.set(this.zoomRect);
        }
        return this.scaleRect;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public Rect getZoomRect() {
        return this.zoomRect;
    }

    public Rect getOriginalRect() {
        return this.originalRect;
    }

    public boolean isCanZoom() {
        this.zoom = 1.0f;
        return this.isCanZoom;
    }

    public OnTableChangeListener getOnTableChangeListener() {
        return this.listener;
    }

    public void setOnTableChangeListener(OnTableChangeListener onTableChangeListener) {
        this.listener = onTableChangeListener;
    }

    public void setCanZoom(boolean canZoom) {
        this.isCanZoom = canZoom;
        if (!this.isCanZoom) {
            this.zoom = 1.0f;
        }
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(float minZoom) {
        if (minZoom < 0.0f) {
            minZoom = 0.1f;
        }
        this.minZoom = minZoom;
    }

    public void setMaxZoom(float maxZoom) {
        if (maxZoom < 1.0f) {
            maxZoom = 1.0f;
        }
        this.maxZoom = maxZoom;
    }

    public void reset() {
        this.zoom = 1.0f;
        this.translateX = 0;
        this.translateY = 0;
        this.notifyViewChanged();
    }

    public void flingLeft(int duration) {
        final int width = this.zoomRect.width();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.zoomRect.left, 0}).setDuration((long)duration);
        valueAnimator.addListener((Animator.AnimatorListener)this.animatorListenerAdapter);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((MatrixHelper)MatrixHelper.this).zoomRect.left = (Integer)animation.getAnimatedValue();
                ((MatrixHelper)MatrixHelper.this).zoomRect.right = ((MatrixHelper)MatrixHelper.this).zoomRect.left + width;
                MatrixHelper.this.notifyViewChanged();
            }
        });
        valueAnimator.start();
    }

    public void flingRight(int duration) {
        final int width = this.zoomRect.width();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.zoomRect.right, this.originalRect.right}).setDuration((long)duration);
        valueAnimator.addListener((Animator.AnimatorListener)this.animatorListenerAdapter);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((MatrixHelper)MatrixHelper.this).zoomRect.right = (Integer)animation.getAnimatedValue();
                ((MatrixHelper)MatrixHelper.this).zoomRect.left = ((MatrixHelper)MatrixHelper.this).zoomRect.right - width;
                MatrixHelper.this.notifyViewChanged();
            }
        });
        valueAnimator.start();
    }

    public void flingTop(int duration) {
        final int height = this.zoomRect.height();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.zoomRect.top, 0}).setDuration((long)duration);
        valueAnimator.addListener((Animator.AnimatorListener)this.animatorListenerAdapter);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((MatrixHelper)MatrixHelper.this).zoomRect.top = (Integer)animation.getAnimatedValue();
                ((MatrixHelper)MatrixHelper.this).zoomRect.bottom = ((MatrixHelper)MatrixHelper.this).zoomRect.top + height;
                MatrixHelper.this.notifyViewChanged();
            }
        });
        valueAnimator.start();
    }

    public void flingBottom(int duration) {
        final int height = this.zoomRect.height();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.zoomRect.bottom, this.originalRect.bottom}).setDuration((long)duration);
        valueAnimator.addListener((Animator.AnimatorListener)this.animatorListenerAdapter);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((MatrixHelper)MatrixHelper.this).zoomRect.bottom = (Integer)animation.getAnimatedValue();
                ((MatrixHelper)MatrixHelper.this).zoomRect.top = ((MatrixHelper)MatrixHelper.this).zoomRect.bottom - height;
                MatrixHelper.this.notifyViewChanged();
            }
        });
        valueAnimator.start();
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getFlingRate() {
        return this.flingRate;
    }

    public void setFlingRate(float flingRate) {
        this.flingRate = flingRate;
    }

    public OnInterceptListener getOnInterceptListener() {
        return this.onInterceptListener;
    }

    public void setOnInterceptListener(OnInterceptListener onInterceptListener) {
        this.onInterceptListener = onInterceptListener;
    }

    public static interface OnInterceptListener {
        public boolean isIntercept(MotionEvent var1, float var2, float var3);
    }

    class OnTableGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        OnTableGestureListener() {
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (MatrixHelper.this.onInterceptListener == null || !MatrixHelper.this.onInterceptListener.isIntercept(e1, distanceX, distanceY)) {
                MatrixHelper.this.translateX = (int)((float)MatrixHelper.this.translateX + distanceX);
                MatrixHelper.this.translateY = (int)((float)MatrixHelper.this.translateY + distanceY);
                MatrixHelper.this.notifyViewChanged();
            }
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (Math.abs(velocityX) > (float)MatrixHelper.this.mMinimumVelocity || Math.abs(velocityY) > (float)MatrixHelper.this.mMinimumVelocity) {
                MatrixHelper.this.scroller.setFinalX(0);
                MatrixHelper.this.scroller.setFinalY(0);
                MatrixHelper.this.tempTranslateX = MatrixHelper.this.translateX;
                MatrixHelper.this.tempTranslateY = MatrixHelper.this.translateY;
                MatrixHelper.this.scroller.fling(0, 0, (int)velocityX, (int)velocityY, -50000, 50000, -50000, 50000);
                MatrixHelper.this.isFling = true;
                MatrixHelper.this.startFilingAnim(false);
            }
            return true;
        }

        public boolean onDown(MotionEvent e) {
            MatrixHelper.this.isFling = false;
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (MatrixHelper.this.isCanZoom) {
                float oldZoom = MatrixHelper.this.zoom;
                if (MatrixHelper.this.isScale) {
                    MatrixHelper.this.zoom = MatrixHelper.this.zoom / 1.5f;
                    if (MatrixHelper.this.zoom < MatrixHelper.this.minZoom) {
                        MatrixHelper.this.zoom = MatrixHelper.this.minZoom;
                        MatrixHelper.this.isScale = false;
                    }
                } else {
                    MatrixHelper.this.zoom = MatrixHelper.this.zoom * 1.5f;
                    if (MatrixHelper.this.zoom > MatrixHelper.this.maxZoom) {
                        MatrixHelper.this.zoom = MatrixHelper.this.maxZoom;
                        MatrixHelper.this.isScale = true;
                    }
                }
                float factor = MatrixHelper.this.zoom / oldZoom;
                MatrixHelper.this.resetTranslate(factor);
                MatrixHelper.this.notifyViewChanged();
            }
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            MatrixHelper.this.notifyViewChanged();
            for (TableClickObserver observer : MatrixHelper.this.observables) {
                observer.onClick(e.getX(), e.getY());
            }
            return true;
        }
    }
}

