/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.format;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.bean.CellInfo;
import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.intface.IDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.utils.DrawUtils;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class TextDrawFormat<T>
implements IDrawFormat<T> {
    private Map<String, SoftReference<String[]>> valueMap = new HashMap<String, SoftReference<String[]>>();

    @Override
    public int measureWidth(Column<T> column, int position) {
        TableConfig config = TableConfig.getInstance();
        Paint paint = config.getPaint();
        config.contentStyle.fillPaint(paint);
        return DrawUtils.getMultiTextWidth(paint, this.getSplitString(column.format(position)));
    }

    @Override
    public int measureHeight(Column<T> column, int position) {
        TableConfig config = TableConfig.getInstance();
        Paint paint = config.getPaint();
        config.contentStyle.fillPaint(paint);
        return DrawUtils.getMultiTextHeight(paint, this.getSplitString(column.format(position)));
    }

    @Override
    public void draw(Canvas c, Rect rect, CellInfo<T> cellInfo) {
        TableConfig config = TableConfig.getInstance();
        Paint paint = config.getPaint();
        this.setTextPaint(config, cellInfo, paint);
        if (cellInfo.column.getTextAlign() != null) {
            paint.setTextAlign(cellInfo.column.getTextAlign());
        }
        this.drawText(c, cellInfo.value, rect, paint);
    }

    protected void drawText(Canvas c, String value, Rect rect, Paint paint) {
        DrawUtils.drawMultiText(c, paint, rect, this.getSplitString(value));
    }

    public void setTextPaint(TableConfig config, CellInfo<T> cellInfo, Paint paint) {
        config.contentStyle.fillPaint(paint);
        paint.setTextSize(paint.getTextSize() * config.getZoom());
    }

    protected String[] getSplitString(String val) {
        String[] values = null;
        if (this.valueMap.get(val) != null) {
            values = this.valueMap.get(val).get();
        }
        if (values == null) {
            values = val.split("\n");
            this.valueMap.put(val, new SoftReference<String[]>(values));
        }
        return values;
    }
}

