/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.component;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.intface.ITableTitle;
import com.didichuxing.doraemonkit.widget.tableview.utils.DrawUtils;

public class TableTitle
implements ITableTitle {
    private int size = 100;
    private Rect rect = new Rect();
    protected int direction;

    @Override
    public void onDraw(Canvas canvas, Rect showRect, String tableName, TableConfig config) {
        Paint paint = config.getPaint();
        config.tableTitleStyle.fillPaint(paint);
        Rect rect = this.getRect();
        int startX = rect.centerX();
        Path path = new Path();
        switch (this.direction) {
            case 1: 
            case 3: {
                DrawUtils.drawMultiText(canvas, paint, rect, tableName.split("\n"));
                break;
            }
            case 0: 
            case 2: {
                int textWidth = (int)paint.measureText(tableName);
                path.moveTo((float)startX, (float)rect.top);
                path.lineTo((float)startX, (float)rect.bottom);
                canvas.drawTextOnPath(tableName, path, (float)(textWidth / 2), 0.0f, paint);
            }
        }
    }

    @Override
    public void onMeasure(Rect scaleRect, Rect showRect, TableConfig config) {
        this.rect.left = showRect.left;
        this.rect.right = showRect.right;
        this.rect.top = showRect.top;
        this.rect.bottom = Math.min(showRect.bottom, scaleRect.bottom);
        int h = this.size;
        int w = this.size;
        switch (this.direction) {
            case 1: {
                this.rect.bottom = this.rect.top + h;
                scaleRect.top += h;
                showRect.top += h;
                break;
            }
            case 0: {
                this.rect.right = this.rect.left + w;
                scaleRect.left += w;
                showRect.left += w;
                break;
            }
            case 2: {
                this.rect.left = this.rect.right - w;
                scaleRect.right -= w;
                showRect.right -= w;
                break;
            }
            case 3: {
                this.rect.top = this.rect.bottom - h;
                scaleRect.bottom -= h;
                showRect.bottom -= h;
            }
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public Rect getRect() {
        return this.rect;
    }

    public void setRect(Rect rect) {
        this.rect = rect;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(int direction) {
        this.direction = direction;
    }
}

