/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.bean;

import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.bean.ColumnInfo;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableInfo;
import com.didichuxing.doraemonkit.widget.tableview.format.NumberSequenceFormat;
import com.didichuxing.doraemonkit.widget.tableview.format.TitleDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.ISequenceFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.ITitleDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnColumnItemClickListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TableData<T> {
    private String tableName;
    private List<Column> columns;
    private List<T> t;
    private List<Column> childColumns;
    private TableInfo tableInfo = new TableInfo();
    private List<ColumnInfo> columnInfos;
    private List<ColumnInfo> childColumnInfos;
    private Column sortColumn;
    private ITitleDrawFormat titleDrawFormat;
    private ISequenceFormat YSequenceFormat;
    private OnItemClickListener onItemClickListener;
    private OnRowClickListener<T> onRowClickListener;
    private OnColumnClickListener<?> onColumnClickListener;

    public TableData(String tableName, List<T> t, List<Column> columns) {
        this(tableName, t, columns, null);
    }

    public TableData(String tableName, List<T> t, Column ... columns) {
        this(tableName, t, Arrays.asList(columns));
    }

    public TableData(String tableName, List<T> t, List<Column> columns, ITitleDrawFormat titleDrawFormat) {
        this.tableName = tableName;
        this.columns = columns;
        this.t = t;
        this.tableInfo.setLineSize(t.size());
        this.childColumns = new ArrayList<Column>();
        this.columnInfos = new ArrayList<ColumnInfo>();
        this.childColumnInfos = new ArrayList<ColumnInfo>();
        this.titleDrawFormat = titleDrawFormat == null ? new TitleDrawFormat() : titleDrawFormat;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<T> getT() {
        return this.t;
    }

    public void setT(List<T> t) {
        this.t = t;
        this.tableInfo.setLineSize(t.size());
    }

    public List<Column> getChildColumns() {
        return this.childColumns;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public List<ColumnInfo> getChildColumnInfos() {
        return this.childColumnInfos;
    }

    public void setChildColumnInfos(List<ColumnInfo> childColumnInfos) {
        this.childColumnInfos = childColumnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public void setChildColumns(List<Column> childColumns) {
        this.childColumns = childColumns;
    }

    public Column getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(Column sortColumn) {
        this.sortColumn = sortColumn;
    }

    public ITitleDrawFormat getTitleDrawFormat() {
        return this.titleDrawFormat;
    }

    public void setTitleDrawFormat(ITitleDrawFormat titleDrawFormat) {
        this.titleDrawFormat = titleDrawFormat;
    }

    public ISequenceFormat getYSequenceFormat() {
        if (this.YSequenceFormat == null) {
            this.YSequenceFormat = new NumberSequenceFormat();
        }
        return this.YSequenceFormat;
    }

    public void setYSequenceFormat(ISequenceFormat YSequenceFormat) {
        this.YSequenceFormat = YSequenceFormat;
    }

    public Column getColumnByID(int id2) {
        List<Column> columns = this.getChildColumns();
        for (Column column : columns) {
            if (column.getId() != id2) continue;
            return column;
        }
        return null;
    }

    public int getLineSize() {
        return this.tableInfo.getLineHeightArray().length;
    }

    public void clear() {
        if (this.t != null) {
            this.t.clear();
            this.t = null;
        }
        if (this.childColumns != null) {
            this.childColumns.clear();
            this.childColumns = null;
        }
        if (this.columns != null) {
            this.columns = null;
        }
        if (this.childColumnInfos != null) {
            this.childColumnInfos.clear();
            this.childColumnInfos = null;
        }
        if (this.tableInfo != null) {
            this.tableInfo.clear();
            this.tableInfo = null;
        }
        this.sortColumn = null;
        this.titleDrawFormat = null;
        this.YSequenceFormat = null;
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public void setOnItemClickListener(final OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        for (Column column : this.columns) {
            column.setOnColumnItemClickListener(new OnColumnItemClickListener(){

                public void onClick(Column column, String value, Object t, int position) {
                    if (onItemClickListener != null) {
                        int index = TableData.this.childColumns.indexOf(column);
                        TableData.this.onItemClickListener.onClick(column, value, t, index, position);
                    }
                }
            });
        }
    }

    public void setOnRowClickListener(OnRowClickListener<T> onRowClickListener) {
        this.onRowClickListener = onRowClickListener;
        if (this.onRowClickListener != null) {
            this.setOnItemClickListener(new OnItemClickListener(){

                public void onClick(Column column, String value, Object o, int col, int row) {
                    TableData.this.onRowClickListener.onClick(column, TableData.this.t.get(row), col, row);
                }
            });
        }
    }

    public void setOnColumnClickListener(OnColumnClickListener onColumnClickListener) {
        this.onColumnClickListener = onColumnClickListener;
        if (this.onRowClickListener != null) {
            this.setOnItemClickListener(new OnItemClickListener(){

                public void onClick(Column column, String value, Object o, int col, int row) {
                    TableData.this.onColumnClickListener.onClick(column, column.getDatas(), col, row);
                }
            });
        }
    }

    public OnRowClickListener getOnRowClickListener() {
        return this.onRowClickListener;
    }

    public static interface OnColumnClickListener<T> {
        public void onClick(Column var1, List<T> var2, int var3, int var4);
    }

    public static interface OnRowClickListener<T> {
        public void onClick(Column var1, T var2, int var3, int var4);
    }

    public static interface OnItemClickListener<T> {
        public void onClick(Column<T> var1, String var2, T var3, int var4, int var5);
    }
}

