/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.dialog;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.widget.dialog.DialogInfo;
import com.didichuxing.doraemonkit.widget.dialog.DialogListener;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;

public class CommonDialogProvider<T extends DialogInfo>
extends DialogProvider<T> {
    private TextView mPositive;
    private TextView mNegative;
    private TextView mTitle;
    private TextView mDesc;

    public CommonDialogProvider(T data, DialogListener listener) {
        super(data, listener);
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_dialog_common;
    }

    @Override
    protected void findViews(View view) {
        this.mPositive = (TextView)view.findViewById(R.id.positive);
        this.mNegative = (TextView)view.findViewById(R.id.negative);
        this.mTitle = (TextView)view.findViewById(R.id.title);
        this.mDesc = (TextView)view.findViewById(R.id.desc);
    }

    @Override
    protected void bindData(T data) {
        this.mTitle.setText(((DialogInfo)data).title);
        if (TextUtils.isEmpty((CharSequence)((DialogInfo)data).desc)) {
            this.mDesc.setVisibility(8);
        } else {
            this.mDesc.setVisibility(0);
            this.mDesc.setText(((DialogInfo)data).desc);
        }
    }

    @Override
    protected View getPositiveView() {
        return this.mPositive;
    }

    @Override
    protected View getNegativeView() {
        return this.mNegative;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

