/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.List;

public class PieChart
extends View {
    private static final float DEFAULT_RING_WIDTH = 19.5f;
    private static final float DEFAULT_SLICE_SPACE = 2.0f;
    private Paint mRenderPaint;
    protected Paint mTransparentCirclePaint;
    private int mHeight;
    private int mWidth;
    private float mRingWidth;
    private float mSliceSpace;
    private List<PieData> mPieData;
    private Path mPath = new Path();
    private float FDEG2RAD = (float)Math.PI / 180;
    private double DEG2RAD = Math.PI / 180;

    public PieChart(Context context) {
        super(context);
        this.setRingWidth(19.5f);
        this.setSliceSpace(2.0f);
        this.initPaint();
    }

    public PieChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setRingWidth(19.5f);
        this.setSliceSpace(2.0f);
        this.initPaint();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPieData == null) {
            return;
        }
        this.drawPie(canvas);
        this.drawHolo(canvas);
    }

    private void initPaint() {
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint = new Paint(1);
        this.mTransparentCirclePaint.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
    }

    private void drawPie(Canvas canvas) {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        Center center = new Center();
        center.x = (float)this.mWidth / 2.0f;
        center.y = (float)this.mHeight / 2.0f;
        float radius = (float)this.mWidth / 2.0f;
        float sliceSpace = this.mSliceSpace;
        float sliceSpaceAngleOuter = this.mPieData.size() == 1 ? 0.0f : sliceSpace / (this.FDEG2RAD * radius);
        float angle = 0.0f;
        for (int i = 0; i < this.mPieData.size(); ++i) {
            PieData data = this.mPieData.get(i);
            this.mRenderPaint.setColor(data.color);
            this.mPath.reset();
            float sliceAngle = data.angel;
            float startAngleOuter = angle + sliceSpaceAngleOuter / 2.0f - 90.0f;
            float sweepAngleOuter = sliceAngle - sliceSpaceAngleOuter;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            angle += sliceAngle;
            if (sweepAngleOuter >= 360.0f) {
                this.mPath.addCircle(center.x, center.y, radius, Path.Direction.CW);
            } else {
                this.mPath.arcTo(rectF, startAngleOuter, sweepAngleOuter);
                float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                float arcStartPointX = center.x + radius * (float)Math.cos(startAngleOuter * this.FDEG2RAD);
                float arcStartPointY = center.y + radius * (float)Math.sin(startAngleOuter * this.FDEG2RAD);
                float sliceSpaceOffset = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                float arcEndPointX = center.x + sliceSpaceOffset * (float)Math.cos(angleMiddle * this.FDEG2RAD);
                float arcEndPointY = center.y + sliceSpaceOffset * (float)Math.sin(angleMiddle * this.FDEG2RAD);
                this.mPath.lineTo(arcEndPointX, arcEndPointY);
            }
            canvas.drawPath(this.mPath, this.mRenderPaint);
        }
    }

    private void drawHolo(Canvas canvas) {
        float holoRadius = (float)this.mWidth / 2.0f - this.mRingWidth;
        canvas.drawCircle((float)this.mWidth / 2.0f, (float)this.mHeight / 2.0f, holoRadius, this.mTransparentCirclePaint);
    }

    protected float calculateMinimumRadiusForSpacedSlice(Center center, float radius, float angle, float arcStartPointX, float arcStartPointY, float startAngle, float sweepAngle) {
        float angleMiddle = startAngle + sweepAngle / 2.0f;
        float arcEndPointX = center.x + radius * (float)Math.cos((startAngle + sweepAngle) * this.FDEG2RAD);
        float arcEndPointY = center.y + radius * (float)Math.sin((startAngle + sweepAngle) * this.FDEG2RAD);
        float arcMidPointX = center.x + radius * (float)Math.cos(angleMiddle * this.FDEG2RAD);
        float arcMidPointY = center.y + radius * (float)Math.sin(angleMiddle * this.FDEG2RAD);
        double basePointsDistance = Math.sqrt(Math.pow(arcEndPointX - arcStartPointX, 2.0) + Math.pow(arcEndPointY - arcStartPointY, 2.0));
        float containedTriangleHeight = (float)(basePointsDistance / 2.0 * Math.tan((180.0 - (double)angle) / 2.0 * this.DEG2RAD));
        float spacedRadius = radius - containedTriangleHeight;
        spacedRadius = (float)((double)spacedRadius - Math.sqrt(Math.pow(arcMidPointX - (arcEndPointX + arcStartPointX) / 2.0f, 2.0) + Math.pow(arcMidPointY - (arcEndPointY + arcStartPointY) / 2.0f, 2.0)));
        return spacedRadius;
    }

    public void setSliceSpace(float space) {
        this.mSliceSpace = UIUtils.dp2px(space);
    }

    public void setRingWidth(float ringWidth) {
        this.mRingWidth = UIUtils.dp2px(ringWidth);
    }

    public void setData(List<PieData> pieData) {
        this.mPieData = pieData;
        int weightSum = 0;
        for (PieData data : pieData) {
            weightSum = (int)((long)weightSum + data.weight);
        }
        for (PieData data : pieData) {
            if (weightSum == 0) {
                data.angel = 360 / pieData.size();
                continue;
            }
            data.angel = (float)data.weight * 360.0f / (float)weightSum;
        }
    }

    private class Center {
        public float x;
        public float y;

        private Center() {
        }
    }

    public static class PieData {
        public final int color;
        public final long weight;
        private float angel;

        public PieData(int color2, long weight) {
            this.color = color2;
            this.weight = weight;
        }
    }
}

