/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;

public class JustifyTextView
extends AppCompatTextView {
    private int mLineY;
    private int mViewWidth;
    public static final String TWO_CHINESE_BLANK = "  ";

    public JustifyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        this.mViewWidth = this.getMeasuredWidth();
        String text = this.getText().toString();
        this.mLineY = 0;
        this.mLineY = (int)((float)this.mLineY + this.getTextSize());
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return;
        }
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
        textHeight = (int)((float)textHeight * layout2.getSpacingMultiplier() + layout2.getSpacingAdd());
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            int lineStart = layout2.getLineStart(i);
            int lineEnd = layout2.getLineEnd(i);
            float width = StaticLayout.getDesiredWidth((CharSequence)text, (int)lineStart, (int)lineEnd, (TextPaint)this.getPaint());
            String line = text.substring(lineStart, lineEnd);
            if (i < layout2.getLineCount() - 1) {
                if (this.needScale(line)) {
                    this.drawScaledText(canvas, lineStart, line, width);
                } else {
                    canvas.drawText(line, 0.0f, (float)this.mLineY, (Paint)paint);
                }
            } else {
                canvas.drawText(line, 0.0f, (float)this.mLineY, (Paint)paint);
            }
            this.mLineY += textHeight;
        }
    }

    private void drawScaledText(Canvas canvas, int lineStart, String line, float lineWidth) {
        float x = 0.0f;
        if (this.isFirstLineOfParagraph(lineStart, line)) {
            String blanks = TWO_CHINESE_BLANK;
            canvas.drawText(blanks, x, (float)this.mLineY, (Paint)this.getPaint());
            float bw = StaticLayout.getDesiredWidth((CharSequence)blanks, (TextPaint)this.getPaint());
            x += bw;
            line = line.substring(3);
        }
        int gapCount = line.length() - 1;
        int i = 0;
        if (line.length() > 2 && line.charAt(0) == '\u3000' && line.charAt(1) == '\u3000') {
            String substring = line.substring(0, 2);
            float cw = StaticLayout.getDesiredWidth((CharSequence)substring, (TextPaint)this.getPaint());
            canvas.drawText(substring, x, (float)this.mLineY, (Paint)this.getPaint());
            x += cw;
            i += 2;
        }
        float d2 = ((float)this.mViewWidth - lineWidth) / (float)gapCount;
        while (i < line.length()) {
            String c = String.valueOf(line.charAt(i));
            float cw = StaticLayout.getDesiredWidth((CharSequence)c, (TextPaint)this.getPaint());
            canvas.drawText(c, x, (float)this.mLineY, (Paint)this.getPaint());
            x += cw + d2;
            ++i;
        }
    }

    private boolean isFirstLineOfParagraph(int lineStart, String line) {
        return line.length() > 3 && line.charAt(0) == ' ' && line.charAt(1) == ' ';
    }

    private boolean needScale(String line) {
        if (line == null || line.length() == 0) {
            return false;
        }
        return line.charAt(line.length() - 1) != '\n';
    }
}

