/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import com.didichuxing.doraemonkit.R;
import java.util.ArrayList;

public class DoKitNotificationUtils {
    private static final String ID_HIGH_CHANNEL = "channel_1_oncar";
    private static final String NAME_HIGH_CHANNEL = "channel_1_name_oncar";
    private static final String ID_LOW_CHANNEL = "channel_low_onecar";
    private static final String NAME_LOW_CHANNEL = "channel_name_low_onecar";
    private static NotificationManager sNotificationManager;
    public static final int ID_SHOW_BLOCK_NOTIFICATION = 1001;

    public static void setMessageNotification(Context context, int notifyId, int smallIconId, CharSequence title, CharSequence summary) {
        DoKitNotificationUtils.setMessageNotification(context, notifyId, smallIconId, title, summary, null);
    }

    public static void setMessageNotification(Context context, int notifyId, int smallIconId, CharSequence title, CharSequence summary, CharSequence ticker) {
        DoKitNotificationUtils.setMessageNotification(context, notifyId, smallIconId, title, summary, ticker, null);
    }

    public static void setMessageNotification(Context context, int notifyId, int smallIconId, CharSequence title, CharSequence summary, CharSequence ticker, PendingIntent pendingIntent) {
        NotificationCompat.Builder builder = Build.VERSION.SDK_INT >= 26 ? new NotificationCompat.Builder(context, ID_HIGH_CHANNEL) : new NotificationCompat.Builder(context);
        builder.setSmallIcon(smallIconId).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.dk_doraemon)).setContentTitle(title).setContentText(summary).setAutoCancel(true).setProgress(0, 0, false);
        if (!TextUtils.isEmpty((CharSequence)ticker)) {
            builder.setTicker(ticker);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        } else {
            builder.setContentIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0x8000000));
        }
        NotificationManager manager = DoKitNotificationUtils.createNotificationManager(context);
        manager.notify(notifyId, builder.build());
    }

    public static void setInfoNotification(Context context, int notifyId, CharSequence title, CharSequence summary, CharSequence ticker, PendingIntent pendingIntent) {
        NotificationCompat.Builder builder = Build.VERSION.SDK_INT >= 26 ? new NotificationCompat.Builder(context, ID_HIGH_CHANNEL) : new NotificationCompat.Builder(context);
        builder.setSmallIcon(R.mipmap.dk_doraemon).setContentTitle(title).setContentText(summary).setAutoCancel(true).setProgress(0, 0, false);
        if (!TextUtils.isEmpty((CharSequence)ticker)) {
            builder.setTicker(ticker);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        } else {
            builder.setContentIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0x8000000));
        }
        NotificationManager manager = DoKitNotificationUtils.createNotificationManager(context);
        manager.notify(notifyId, builder.build());
    }

    public static void setProgressNotification(Context context, int notifyId, CharSequence title, int progress) {
        DoKitNotificationUtils.setProgressNotification(context, notifyId, title, null, progress);
    }

    public static void setProgressNotification(Context context, int notifyId, CharSequence title, CharSequence ticker, int progress) {
        DoKitNotificationUtils.setProgressNotification(context, notifyId, title, ticker, progress, null);
    }

    public static void setProgressNotification(Context context, int notifyId, CharSequence title, CharSequence ticker, int progress, PendingIntent pendingIntent) {
        NotificationCompat.Builder builder = Build.VERSION.SDK_INT >= 26 ? new NotificationCompat.Builder(context, ID_HIGH_CHANNEL) : new NotificationCompat.Builder(context);
        builder.setSmallIcon(0x1080081).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.dk_doraemon)).setContentTitle(title).setProgress(100, progress, progress == 0).setOngoing(progress < 100).setAutoCancel(progress == 100);
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        } else {
            builder.setContentIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0x8000000));
        }
        if (!TextUtils.isEmpty((CharSequence)ticker)) {
            builder.setTicker(ticker);
        }
        NotificationManager manager = DoKitNotificationUtils.createNotificationManager(context);
        manager.notify(notifyId, builder.build());
    }

    public static void cancelNotification(Context context, int notifyId) {
        NotificationManager manager = DoKitNotificationUtils.createNotificationManager(context);
        manager.cancel(notifyId);
    }

    public static void cancelNotification(Context context) {
        NotificationManager manager = DoKitNotificationUtils.createNotificationManager(context);
        manager.cancelAll();
    }

    private static NotificationManager createNotificationManager(Context context) {
        if (sNotificationManager != null) {
            return sNotificationManager;
        }
        sNotificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationHightChannel = new NotificationChannel(ID_HIGH_CHANNEL, (CharSequence)NAME_HIGH_CHANNEL, 4);
            NotificationChannel notificationLowChannel = new NotificationChannel(ID_LOW_CHANNEL, (CharSequence)NAME_LOW_CHANNEL, 2);
            ArrayList<NotificationChannel> channelList = new ArrayList<NotificationChannel>();
            channelList.add(notificationLowChannel);
            channelList.add(notificationHightChannel);
            sNotificationManager.createNotificationChannels(channelList);
        }
        return sNotificationManager;
    }
}

