/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.format.Formatter;
import androidx.core.content.FileProvider;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.File;
import java.util.Locale;

public class DoKitFileUtil {
    private static final String TAG = "FileUtil";
    public static final String TXT = "txt";
    public static final String JPG = "jpg";
    public static final String DB = "db";
    public static final String SHARED_PREFS = "shared_prefs";
    public static final String XML = ".xml";

    private DoKitFileUtil() {
    }

    public static String getFileSize(Context context, File file) {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return Formatter.formatFileSize((Context)context, (long)file.length());
    }

    public static String getSuffix(File file) {
        if (file == null || !file.exists()) {
            return "";
        }
        return file.getName().substring(file.getName().lastIndexOf(".") + 1).toLowerCase(Locale.getDefault());
    }

    public static void systemShare(Context context, File file) {
        if (file == null || !file.exists()) {
            return;
        }
        Intent intent = new Intent("android.intent.action.SEND");
        intent.addFlags(1);
        intent.addFlags(0x10000000);
        try {
            Uri uri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".debugfileprovider"), (File)file);
            String type = context.getContentResolver().getType(uri);
            intent.setDataAndType(uri, type);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            if (intent.resolveActivity(context.getPackageManager()) == null) {
                intent.setDataAndType(uri, "*/*");
            }
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogHelper.e(TAG, "The selected file can't be shared: " + file.toString());
        }
    }

    public static boolean isImage(File file) {
        if (file == null) {
            return false;
        }
        String suffix = DoKitFileUtil.getSuffix(file);
        return JPG.equals(suffix) || "jpeg".equals(suffix) || "png".equals(suffix) || "bmp".equals(suffix);
    }

    public static boolean isVideo(File file) {
        if (file == null) {
            return false;
        }
        String suffix = DoKitFileUtil.getSuffix(file);
        return "3gp".equals(suffix) || "mp4".equals(suffix) || "mkv".equals(suffix) || "webm".equals(suffix);
    }

    public static boolean isDB(File file) {
        if (file == null) {
            return false;
        }
        String suffix = DoKitFileUtil.getSuffix(file);
        return DB.equals(suffix);
    }

    public static boolean isSp(File file) {
        File parentFile = file.getParentFile();
        return parentFile != null && parentFile.getName().equals(SHARED_PREFS) && file.getName().contains(XML);
    }

    public static void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] listFiles;
            for (File f : listFiles = file.listFiles()) {
                DoKitFileUtil.deleteDirectory(f);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static long getDirectorySize(File directory) {
        long size = 0L;
        File[] listFiles = directory.listFiles();
        if (listFiles == null) {
            return size;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                size += DoKitFileUtil.getDirectorySize(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }
}

