/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.weaknetwork;

import android.os.SystemClock;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class SpeedLimitResponseBody
extends ResponseBody {
    private static String TAG = "SpeedLimitResponseBody";
    private long mSpeedByte;
    private ResponseBody mResponseBody;
    private BufferedSource mBufferedSource;

    SpeedLimitResponseBody(long speed, ResponseBody source) {
        this.mResponseBody = source;
        this.mSpeedByte = speed * 1024L;
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long cacheTotalBytesRead;
            private long cacheStartTime;

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead;
                if (this.cacheStartTime == 0L) {
                    this.cacheStartTime = SystemClock.uptimeMillis();
                }
                if ((bytesRead = super.read(sink.buffer(), 1024L)) == -1L) {
                    return bytesRead;
                }
                this.cacheTotalBytesRead += bytesRead;
                long costTime = SystemClock.uptimeMillis() - this.cacheStartTime;
                if (costTime <= 1000L && this.cacheTotalBytesRead >= SpeedLimitResponseBody.this.mSpeedByte) {
                    long sleep = 1000L - costTime;
                    SystemClock.sleep((long)sleep);
                    this.cacheStartTime = 0L;
                    this.cacheTotalBytesRead = 0L;
                }
                return bytesRead;
            }
        };
    }
}

