/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.viewcheck;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentManager;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.viewcheck.ViewCheckDokitView;
import com.didichuxing.doraemonkit.kit.viewcheck.ViewCheckDrawDokitView;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.ColorUtil;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.List;

public class ViewCheckInfoDokitView
extends AbsDokitView
implements ViewCheckDokitView.OnViewSelectListener,
View.OnClickListener {
    private TextView mName;
    private TextView mId;
    private TextView mPosition;
    private TextView mDesc;
    private TextView mActivityInfo;
    private TextView mFragmentInfo;
    private ImageView mPre;
    private ImageView mNext;
    private ImageView mClose;

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ViewCheckDokitView dokitView = DoKit.getDoKitView(this.getActivity(), ViewCheckDokitView.class);
        if (dokitView != null) {
            dokitView.removeViewSelectListener(this);
        }
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_view_check_info, null);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.mId = (TextView)this.findViewById(R.id.id);
        this.mName = (TextView)this.findViewById(R.id.name);
        this.mPosition = (TextView)this.findViewById(R.id.position);
        this.mDesc = (TextView)this.findViewById(R.id.desc);
        this.mActivityInfo = (TextView)this.findViewById(R.id.activity);
        this.mFragmentInfo = (TextView)this.findViewById(R.id.fragment);
        this.mClose = (ImageView)this.findViewById(R.id.close);
        this.mClose.setOnClickListener((View.OnClickListener)this);
        this.mPre = (ImageView)this.findViewById(R.id.pre);
        this.mPre.setOnClickListener((View.OnClickListener)this);
        this.mNext = (ImageView)this.findViewById(R.id.next);
        this.mNext.setOnClickListener((View.OnClickListener)this);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ViewCheckDokitView dokitView = DoKit.getDoKitView(ViewCheckInfoDokitView.this.getActivity(), ViewCheckDokitView.class);
                if (dokitView != null) {
                    dokitView.setViewSelectListener(ViewCheckInfoDokitView.this);
                }
            }
        }, 200L);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.flags = DokitViewLayoutParams.FLAG_NOT_FOCUSABLE;
        params.x = 0;
        params.y = UIUtils.getHeightPixels() - UIUtils.dp2px(185.0f);
        params.width = this.getScreenShortSideLength();
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
    }

    @Override
    public void updateViewLayout(String tag, boolean isActivityBackResume) {
        super.updateViewLayout(tag, isActivityBackResume);
        FrameLayout.LayoutParams params = this.getNormalLayoutParams();
        params.height = -2;
        this.getDoKitView().setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void onClick(View v) {
        ViewCheckDokitView dokitView;
        if (v == this.mClose) {
            DoKit.removeFloating(ViewCheckDrawDokitView.class);
            DoKit.removeFloating(ViewCheckInfoDokitView.class);
            DoKit.removeFloating(ViewCheckDokitView.class);
        }
        if (v == this.mNext && (dokitView = DoKit.getDoKitView(this.getActivity(), ViewCheckDokitView.class)) != null) {
            dokitView.preformNextCheckView();
        }
        if (v == this.mPre && (dokitView = DoKit.getDoKitView(this.getActivity(), ViewCheckDokitView.class)) != null) {
            dokitView.preformPreCheckView();
        }
    }

    @Override
    public void onViewSelected(@Nullable View current, @NonNull List<View> checkViewList) {
        this.mNext.setVisibility(checkViewList.size() > 1 ? 0 : 8);
        this.mPre.setVisibility(checkViewList.size() > 1 ? 0 : 8);
        if (current == null) {
            this.mName.setText((CharSequence)"");
            this.mId.setText((CharSequence)"");
            this.mPosition.setText((CharSequence)"");
            this.mDesc.setText((CharSequence)"");
        } else {
            this.mName.setText((CharSequence)this.getResources().getString(R.string.dk_view_check_info_class, new Object[]{current.getClass().getCanonicalName()}));
            String idText = this.getResources().getString(R.string.dk_view_check_info_id, new Object[]{UIUtils.getIdText(current)});
            this.mId.setText((CharSequence)idText);
            String positionText = this.getResources().getString(R.string.dk_view_check_info_size, new Object[]{current.getWidth(), current.getHeight()});
            this.mPosition.setText((CharSequence)positionText);
            String descText = this.getViewExtraInfo(current);
            if (TextUtils.isEmpty((CharSequence)descText)) {
                this.mDesc.setVisibility(8);
            } else {
                this.mDesc.setText((CharSequence)descText);
                this.mDesc.setVisibility(0);
            }
            Activity activity = ActivityUtils.getTopActivity();
            if (activity != null) {
                String activityText = activity.getClass().getSimpleName();
                this.setTextAndVisible(this.mActivityInfo, this.getResources().getString(R.string.dk_view_check_info_activity, new Object[]{activityText}));
                String fragmentText = this.getVisibleFragment(activity);
                if (!TextUtils.isEmpty((CharSequence)fragmentText)) {
                    this.setTextAndVisible(this.mFragmentInfo, this.getResources().getString(R.string.dk_view_check_info_fragment, new Object[]{fragmentText}));
                } else {
                    this.setTextAndVisible(this.mFragmentInfo, "");
                }
            } else {
                this.setTextAndVisible(this.mActivityInfo, "");
                this.setTextAndVisible(this.mFragmentInfo, "");
            }
        }
    }

    private String getViewExtraInfo(View v) {
        ViewGroup.LayoutParams layoutParams;
        StringBuilder info = new StringBuilder();
        Drawable drawable2 = v.getBackground();
        if (drawable2 != null && drawable2 instanceof ColorDrawable) {
            int colorInt = ((ColorDrawable)drawable2).getColor();
            String backgroundColor = ColorUtil.parseColorInt(colorInt);
            info.append(this.getResources().getString(R.string.dk_view_check_info_desc, new Object[]{backgroundColor}));
            info.append("\n");
        }
        if (v.getPaddingLeft() != 0 && v.getPaddingTop() != 0 && v.getPaddingRight() != 0 && v.getPaddingBottom() != 0) {
            info.append(this.getResources().getString(R.string.dk_view_check_info_padding, new Object[]{v.getPaddingLeft(), v.getPaddingTop(), v.getPaddingRight(), v.getPaddingBottom()}));
            info.append("\n");
        }
        if ((layoutParams = v.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mp = (ViewGroup.MarginLayoutParams)layoutParams;
            if (mp.leftMargin != 0 && mp.topMargin != 0 && mp.rightMargin != 0 && mp.bottomMargin != 0) {
                info.append(this.getResources().getString(R.string.dk_view_check_info_margin, new Object[]{mp.leftMargin, mp.topMargin, mp.rightMargin, mp.bottomMargin}));
                info.append("\n");
            }
        }
        if (v instanceof TextView) {
            TextView tv = (TextView)v;
            String textColor = ColorUtil.parseColorInt(tv.getCurrentTextColor());
            info.append(this.getResources().getString(R.string.dk_view_check_info_text_color, new Object[]{textColor}));
            info.append("\n");
            info.append(this.getResources().getString(R.string.dk_view_check_info_text_size, new Object[]{(int)tv.getTextSize()}));
            info.append("\n");
        }
        if (!TextUtils.isEmpty((CharSequence)info)) {
            info.deleteCharAt(info.length() - 1);
        }
        return info.toString();
    }

    private void setTextAndVisible(TextView textView, String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
            textView.setText((CharSequence)"");
        } else {
            textView.setVisibility(0);
            textView.setText((CharSequence)text);
        }
    }

    private String getVisibleFragment(Activity activity) {
        if (activity == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (activity instanceof AppCompatActivity) {
            AppCompatActivity compatActivity = (AppCompatActivity)activity;
            FragmentManager fragmentManager = compatActivity.getSupportFragmentManager();
            List fragments = fragmentManager.getFragments();
            if (fragments != null && fragments.size() != 0) {
                for (int i = 0; i < fragments.size(); ++i) {
                    androidx.fragment.app.Fragment fragment = (androidx.fragment.app.Fragment)fragments.get(i);
                    if (fragment == null || !fragment.isVisible()) continue;
                    builder.append(fragment.getClass().getSimpleName() + "#" + fragment.getId());
                    if (i >= fragments.size() - 1) continue;
                    builder.append(";");
                }
                return builder.toString();
            }
            return this.getFragmentForActivity(activity);
        }
        return this.getFragmentForActivity(activity);
    }

    private String getFragmentForActivity(Activity activity) {
        android.app.FragmentManager manager;
        List list;
        StringBuilder builder = new StringBuilder();
        if (Build.VERSION.SDK_INT >= 26 && (list = (manager = activity.getFragmentManager()).getFragments()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Fragment fragment = (Fragment)list.get(i);
                if (fragment == null || !fragment.isVisible()) continue;
                builder.append(fragment.getClass().getSimpleName() + "#" + fragment.getId());
                if (i >= list.size() - 1) continue;
                builder.append(";");
            }
        }
        return builder.toString();
    }
}

