/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.viewcheck;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.LifecycleListenerUtil;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class ViewCheckDokitView
extends AbsDokitView
implements LifecycleListenerUtil.LifecycleListener {
    private static final String TAG = "ViewCheckFloatPage";
    private FindCheckViewRunnable mFindCheckViewRunnable;
    private HandlerThread mTraverHandlerThread;
    private Handler mTraverHandler;
    private List<OnViewSelectListener> mViewSelectListeners = new ArrayList<OnViewSelectListener>();
    private Activity mResumedActivity;

    @Override
    public void onCreate(Context context) {
        this.mTraverHandlerThread = new HandlerThread(TAG);
        this.mTraverHandlerThread.start();
        this.mTraverHandler = new Handler(this.mTraverHandlerThread.getLooper());
        this.mFindCheckViewRunnable = new FindCheckViewRunnable();
        this.mResumedActivity = ActivityUtils.getTopActivity();
        LifecycleListenerUtil.registerListener(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mTraverHandler.removeCallbacks((Runnable)this.mFindCheckViewRunnable);
        this.mTraverHandlerThread.quit();
        LifecycleListenerUtil.unRegisterListener(this);
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_view_check, null);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.x = UIUtils.getWidthPixels() / 2;
        params.y = UIUtils.getHeightPixels() / 2;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
    }

    @Override
    public void onUp(int x, int y) {
        super.onUp(x, y);
        this.preformFindCheckView();
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.mResumedActivity = activity;
        this.preformFindCheckView();
    }

    @Override
    public void onViewCreated(FrameLayout view) {
    }

    @Override
    public void onActivityPaused(Activity activity) {
    }

    @Override
    public void onFragmentAttached(Fragment f) {
    }

    @Override
    public void onFragmentDetached(Fragment f) {
    }

    @Override
    public void onDown(int x, int y) {
    }

    void setViewSelectListener(OnViewSelectListener viewSelectListener) {
        this.mViewSelectListeners.add(viewSelectListener);
        this.preformFindCheckView();
    }

    void removeViewSelectListener(OnViewSelectListener viewSelectListener) {
        this.mViewSelectListeners.remove(viewSelectListener);
    }

    void preformPreCheckView() {
        this.mFindCheckViewRunnable.mIndex--;
        if (this.mFindCheckViewRunnable.mIndex < 0) {
            FindCheckViewRunnable findCheckViewRunnable = this.mFindCheckViewRunnable;
            findCheckViewRunnable.mIndex = findCheckViewRunnable.mIndex + this.mFindCheckViewRunnable.mCheckViewList.size();
        }
        this.mFindCheckViewRunnable.dispatchOnViewSelected();
    }

    void preformNextCheckView() {
        this.mFindCheckViewRunnable.mIndex++;
        if (this.mFindCheckViewRunnable.mIndex >= this.mFindCheckViewRunnable.mCheckViewList.size()) {
            FindCheckViewRunnable findCheckViewRunnable = this.mFindCheckViewRunnable;
            findCheckViewRunnable.mIndex = findCheckViewRunnable.mIndex - this.mFindCheckViewRunnable.mCheckViewList.size();
        }
        this.mFindCheckViewRunnable.dispatchOnViewSelected();
    }

    private void preformFindCheckView() {
        int y;
        int x;
        if (this.isNormalMode()) {
            x = this.getNormalLayoutParams().leftMargin + this.getDoKitView().getWidth() / 2;
            y = this.getNormalLayoutParams().topMargin + this.getDoKitView().getHeight() / 2;
        } else {
            x = this.getSystemLayoutParams().x + this.getDoKitView().getWidth() / 2;
            y = this.getSystemLayoutParams().y + this.getDoKitView().getHeight() / 2;
        }
        this.mTraverHandler.removeCallbacks((Runnable)this.mFindCheckViewRunnable);
        this.mFindCheckViewRunnable.mX = x;
        this.mFindCheckViewRunnable.mY = y;
        this.mTraverHandler.post((Runnable)this.mFindCheckViewRunnable);
    }

    private void traverseViews(List<View> viewList, View view, int x, int y) {
        if (view == null) {
            return;
        }
        int[] location = new int[2];
        view.getLocationInWindow(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getWidth();
        int bottom = top + view.getHeight();
        if (view instanceof ViewGroup) {
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = childCount - 1; index >= 0; --index) {
                    this.traverseViews(viewList, ((ViewGroup)view).getChildAt(index), x, y);
                }
            }
            if (left < x && x < right && top < y && y < bottom) {
                viewList.add(view);
            }
        } else if (left < x && x < right && top < y && y < bottom) {
            viewList.add(view);
        }
    }

    private void onViewSelected(View current, List<View> checkViewList) {
        for (OnViewSelectListener listener : this.mViewSelectListeners) {
            listener.onViewSelected(current, checkViewList);
        }
    }

    class FindCheckViewRunnable
    implements Runnable {
        private int mX = 0;
        private int mY = 0;
        private int mIndex = 0;
        private List<View> mCheckViewList;

        FindCheckViewRunnable() {
        }

        @Override
        public void run() {
            ArrayList<View> viewList = new ArrayList<View>(20);
            if (ViewCheckDokitView.this.mResumedActivity != null && ViewCheckDokitView.this.mResumedActivity.getWindow() != null) {
                if (ViewCheckDokitView.this.isNormalMode()) {
                    ViewCheckDokitView.this.traverseViews(viewList, UIUtils.getDokitAppContentView(ViewCheckDokitView.this.mResumedActivity), this.mX, this.mY);
                } else {
                    ViewCheckDokitView.this.traverseViews(viewList, ViewCheckDokitView.this.mResumedActivity.getWindow().getDecorView(), this.mX, this.mY);
                }
            }
            this.mIndex = 0;
            this.mCheckViewList = viewList;
            this.dispatchOnViewSelected();
        }

        private void dispatchOnViewSelected() {
            ViewCheckDokitView.this.post(new Runnable(){

                @Override
                public void run() {
                    ViewCheckDokitView.this.onViewSelected(FindCheckViewRunnable.this.getCurrentCheckView(), FindCheckViewRunnable.this.mCheckViewList);
                }
            });
        }

        private View getCurrentCheckView() {
            int size = this.mCheckViewList.size();
            if (size == 0) {
                return null;
            }
            return this.mCheckViewList.get(this.mIndex);
        }
    }

    static interface OnViewSelectListener {
        public void onViewSelected(@Nullable View var1, @NonNull List<View> var2);
    }
}

