/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.viewcheck;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;

public class AimCircleView
extends View {
    private Paint mPaint;

    public AimCircleView(Context context) {
        super(context);
        this.init();
    }

    public AimCircleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AimCircleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircle(canvas);
    }

    private void drawCircle(Canvas canvas) {
        float cx = this.getWidth() / 2;
        float cy = this.getWidth() / 2;
        float radius = this.getWidth() / 2;
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_FFFFFF));
        this.mPaint.setAlpha(100);
        canvas.drawCircle(cx, cy, radius, this.mPaint);
        radius = this.getResources().getDimensionPixelSize(R.dimen.dk_dp_40) / 2;
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_30CC3A4B));
        this.mPaint.setAlpha(50);
        canvas.drawCircle(cx, cy, radius, this.mPaint);
        radius = this.getResources().getDimensionPixelSize(R.dimen.dk_dp_5) / 2;
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_CC3A4B));
        canvas.drawCircle(cx, cy, radius, this.mPaint);
        radius = this.getWidth() / 2;
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(4.0f);
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_337CC4));
        this.mPaint.setAlpha(100);
        canvas.drawCircle(cx, cy, radius - 2.0f, this.mPaint);
    }
}

