/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.toolpanel.decoration;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.didichuxing.doraemonkit.kit.toolpanel.decoration.HorizontalDividerItemDecoration;
import com.didichuxing.doraemonkit.kit.toolpanel.decoration.VerticalDividerItemDecoration;

public abstract class FlexibleDividerDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEFAULT_SIZE = 2;
    private static final int[] ATTRS = new int[]{16843284};
    protected DividerType mDividerType = DividerType.DRAWABLE;
    protected VisibilityProvider mVisibilityProvider;
    protected PaintProvider mPaintProvider;
    protected ColorProvider mColorProvider;
    protected DrawableProvider mDrawableProvider;
    protected SizeProvider mSizeProvider;
    protected SizeProvider mSpaceProvider;
    protected boolean mShowLastDivider;
    protected boolean mPositionInsideItem;
    private Paint mPaint;

    protected FlexibleDividerDecoration(Builder builder) {
        if (builder.mPaintProvider != null) {
            this.mDividerType = DividerType.PAINT;
            this.mPaintProvider = builder.mPaintProvider;
        } else if (builder.mColorProvider != null) {
            this.mDividerType = DividerType.COLOR;
            this.mColorProvider = builder.mColorProvider;
            this.mPaint = new Paint();
            this.setSizeProvider(builder);
        } else if (builder.mSpaceProvider != null) {
            this.mDividerType = DividerType.SPACE;
            this.mSpaceProvider = builder.mSpaceProvider;
        } else {
            this.mDividerType = DividerType.DRAWABLE;
            if (builder.mDrawableProvider == null) {
                TypedArray a = builder.mContext.obtainStyledAttributes(ATTRS);
                final Drawable divider = a.getDrawable(0);
                a.recycle();
                this.mDrawableProvider = new DrawableProvider(){

                    @Override
                    public Drawable drawableProvider(int position, RecyclerView parent) {
                        return divider;
                    }
                };
            } else {
                this.mDrawableProvider = builder.mDrawableProvider;
            }
            this.mSizeProvider = builder.mSizeProvider;
        }
        this.mVisibilityProvider = builder.mVisibilityProvider;
        this.mShowLastDivider = builder.mShowLastDivider;
        this.mPositionInsideItem = builder.mPositionInsideItem;
    }

    private void setSizeProvider(Builder builder) {
        this.mSizeProvider = builder.mSizeProvider;
        if (this.mSizeProvider == null) {
            this.mSizeProvider = new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return 2;
                }
            };
        }
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter == null) {
            return;
        }
        int validChildCount = parent.getChildCount();
        block5: for (int i = 0; i < validChildCount; ++i) {
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildAdapterPosition(child);
            if (!this.hasDivider(parent, childPosition) || this.mVisibilityProvider.shouldHideDivider(childPosition, parent)) continue;
            Rect bounds = this.getDividerBound(childPosition, parent, child);
            switch (this.mDividerType) {
                case DRAWABLE: {
                    Drawable drawable2 = this.mDrawableProvider.drawableProvider(childPosition, parent);
                    drawable2.setBounds(bounds);
                    drawable2.draw(c);
                    continue block5;
                }
                case PAINT: {
                    this.mPaint = this.mPaintProvider.dividerPaint(childPosition, parent);
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                    continue block5;
                }
                case COLOR: {
                    this.mPaint.setColor(this.mColorProvider.dividerColor(childPosition, parent));
                    this.mPaint.setStrokeWidth((float)this.mSizeProvider.dividerSize(childPosition, parent));
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                    continue block5;
                }
            }
        }
    }

    public boolean hasDivider(RecyclerView parent, int childPosition) {
        if (this.mShowLastDivider) {
            return true;
        }
        if (this instanceof VerticalDividerItemDecoration) {
            return this.hasVerticalDivider(parent, childPosition);
        }
        if (this instanceof HorizontalDividerItemDecoration) {
            return this.hasHorizontalDivider(parent, childPosition);
        }
        return false;
    }

    private boolean hasVerticalDivider(RecyclerView parent, int position) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        int itemCount = adapter.getItemCount();
        int lastDividerOffset = this.getLastDividerOffset(parent);
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)parent.getLayoutManager();
            int spanCount = manager.getSpanCount();
            if (manager.getOrientation() == 1) {
                return this.positionTotalSpanSize(manager, position) != spanCount;
            }
            if (manager.getReverseLayout()) {
                return manager.getSpanSizeLookup().getSpanGroupIndex(position, spanCount) != 0;
            }
            return position < itemCount - lastDividerOffset;
        }
        if (parent.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)parent.getLayoutManager();
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
            int spanCount = manager.getSpanCount();
            int spanIndex = params.getSpanIndex();
            if (manager.getOrientation() == 1) {
                return spanIndex < spanCount - 1;
            }
            int[] lastPosition = null;
            lastPosition = manager.getReverseLayout() ? manager.findFirstVisibleItemPositions(null) : manager.findLastVisibleItemPositions(null);
            boolean hasDirectionAlign = false;
            for (int p : lastPosition) {
                StaggeredGridLayoutManager.LayoutParams params1;
                if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                hasDirectionAlign = true;
                break;
            }
            return hasDirectionAlign;
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            if (((LinearLayoutManager)parent.getLayoutManager()).getReverseLayout()) {
                return position > 0;
            }
            return position < itemCount - 1;
        }
        return false;
    }

    private boolean hasHorizontalDivider(RecyclerView parent, int position) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        int itemCount = adapter.getItemCount();
        int lastDividerOffset = this.getLastDividerOffset(parent);
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)parent.getLayoutManager();
            int spanCount = manager.getSpanCount();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    GridLayoutManager.SpanSizeLookup lookup = manager.getSpanSizeLookup();
                    return lookup.getSpanGroupIndex(position, spanCount) != 0;
                }
                return position < itemCount - lastDividerOffset;
            }
            return this.positionTotalSpanSize(manager, position) != spanCount;
        }
        if (parent.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)parent.getLayoutManager();
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
            int spanCount = manager.getSpanCount();
            int spanIndex = params.getSpanIndex();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    return position > spanCount - 1;
                }
                int[] lastPosition = manager.findLastVisibleItemPositions(null);
                boolean hasBottom = false;
                for (int p : lastPosition) {
                    StaggeredGridLayoutManager.LayoutParams params1;
                    if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                    hasBottom = true;
                    break;
                }
                return hasBottom;
            }
            return spanIndex < spanCount - 1;
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            if (((LinearLayoutManager)parent.getLayoutManager()).getReverseLayout()) {
                return position > 0;
            }
            return position < itemCount - 1;
        }
        return false;
    }

    protected int positionTotalSpanSize(GridLayoutManager manager, int position) {
        int thisGroupIndex;
        int totalSpanSize = 0;
        GridLayoutManager.SpanSizeLookup spanSizeLookup = manager.getSpanSizeLookup();
        int spanCount = manager.getSpanCount();
        int groupIndex = spanSizeLookup.getSpanGroupIndex(position, spanCount);
        for (int i = position; i >= 0 && (thisGroupIndex = spanSizeLookup.getSpanGroupIndex(i, spanCount)) == groupIndex; --i) {
            totalSpanSize += spanSizeLookup.getSpanSize(i);
        }
        return totalSpanSize;
    }

    public void getItemOffsets(Rect rect, View v, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(v);
        if (!this.hasDivider(parent, position)) {
            return;
        }
        if (this.mVisibilityProvider.shouldHideDivider(position, parent)) {
            return;
        }
        this.setItemOffsets(rect, position, parent);
    }

    private int getLastDividerOffset(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            int itemCount = parent.getAdapter().getItemCount();
            for (int i = itemCount - 1; i >= 0; --i) {
                if (spanSizeLookup.getSpanIndex(i, spanCount) != 0) continue;
                return itemCount - i;
            }
        }
        return 1;
    }

    protected abstract Rect getDividerBound(int var1, RecyclerView var2, View var3);

    protected abstract void setItemOffsets(Rect var1, int var2, RecyclerView var3);

    public static class Builder<T extends Builder> {
        private Context mContext;
        protected Resources mResources;
        private PaintProvider mPaintProvider;
        private ColorProvider mColorProvider;
        private DrawableProvider mDrawableProvider;
        private SizeProvider mSizeProvider;
        private SizeProvider mSpaceProvider;
        private VisibilityProvider mVisibilityProvider = new VisibilityProvider(){

            @Override
            public boolean shouldHideDivider(int position, RecyclerView parent) {
                return false;
            }
        };
        private boolean mShowLastDivider = false;
        private boolean mPositionInsideItem = false;

        public Builder(Context context) {
            this.mContext = context;
            this.mResources = context.getResources();
        }

        public T paint(final Paint paint) {
            return this.paintProvider(new PaintProvider(){

                @Override
                public Paint dividerPaint(int position, RecyclerView parent) {
                    return paint;
                }
            });
        }

        public T paintProvider(PaintProvider provider) {
            this.mPaintProvider = provider;
            return (T)this;
        }

        public T color(final int color2) {
            return this.colorProvider(new ColorProvider(){

                @Override
                public int dividerColor(int position, RecyclerView parent) {
                    return color2;
                }
            });
        }

        public T colorResId(@ColorRes int colorId) {
            return this.color(ContextCompat.getColor((Context)this.mContext, (int)colorId));
        }

        public T colorProvider(ColorProvider provider) {
            this.mColorProvider = provider;
            return (T)this;
        }

        public T drawable(@DrawableRes int id2) {
            return this.drawable(ContextCompat.getDrawable((Context)this.mContext, (int)id2));
        }

        public T drawable(final Drawable drawable2) {
            return this.drawableProvider(new DrawableProvider(){

                @Override
                public Drawable drawableProvider(int position, RecyclerView parent) {
                    return drawable2;
                }
            });
        }

        public T drawableProvider(DrawableProvider provider) {
            this.mDrawableProvider = provider;
            return (T)this;
        }

        public T size(final int size) {
            return this.sizeProvider(new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return size;
                }
            });
        }

        public T sizeResId(@DimenRes int sizeId) {
            return this.size(this.mResources.getDimensionPixelSize(sizeId));
        }

        public T sizeProvider(SizeProvider provider) {
            this.mSizeProvider = provider;
            return (T)this;
        }

        public T space(final int space) {
            return this.spaceProvider(new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return space;
                }
            });
        }

        public T spaceResId(@DimenRes int spaceId) {
            return this.space(this.mResources.getDimensionPixelSize(spaceId));
        }

        public T spaceProvider(SizeProvider provider) {
            this.mSpaceProvider = provider;
            return (T)this;
        }

        public T visibilityProvider(VisibilityProvider provider) {
            this.mVisibilityProvider = provider;
            return (T)this;
        }

        public T showLastDivider() {
            this.mShowLastDivider = true;
            return (T)this;
        }

        public T positionInsideItem(boolean positionInsideItem) {
            this.mPositionInsideItem = positionInsideItem;
            return (T)this;
        }

        protected void checkBuilderParams() {
            if (this.mPaintProvider != null) {
                if (this.mColorProvider != null) {
                    throw new IllegalArgumentException("Use setColor method of Paint class to specify line color. Do not provider ColorProvider if you set PaintProvider.");
                }
                if (this.mSizeProvider != null) {
                    throw new IllegalArgumentException("Use setStrokeWidth method of Paint class to specify line size. Do not provider SizeProvider if you set PaintProvider.");
                }
            }
        }
    }

    public static interface SizeProvider {
        public int dividerSize(int var1, RecyclerView var2);
    }

    public static interface DrawableProvider {
        public Drawable drawableProvider(int var1, RecyclerView var2);
    }

    public static interface ColorProvider {
        public int dividerColor(int var1, RecyclerView var2);
    }

    public static interface PaintProvider {
        public Paint dividerPaint(int var1, RecyclerView var2);
    }

    public static interface VisibilityProvider {
        public boolean shouldHideDivider(int var1, RecyclerView var2);
    }

    protected static enum DividerType {
        DRAWABLE,
        PAINT,
        COLOR,
        SPACE;

    }
}

