/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter.counter;

import android.app.Activity;
import android.os.SystemClock;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterDokitView;
import com.didichuxing.doraemonkit.kit.timecounter.bean.CounterInfo;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import java.util.ArrayList;
import java.util.List;

public class ActivityCounter {
    private static final String TAG = "ActivityCounter";
    private long mStartTime;
    private long mPauseCostTime;
    private long mLaunchStartTime;
    private long mLaunchCostTime;
    private long mRenderStartTime;
    private long mRenderCostTime;
    private long mTotalCostTime;
    private long mOtherCostTime;
    private String mPreviousActivity;
    private String mCurrentActivity;
    private List<CounterInfo> mCounterInfos = new ArrayList<CounterInfo>();

    public void pause() {
        this.mStartTime = SystemClock.elapsedRealtime();
        this.mPauseCostTime = 0L;
        this.mRenderCostTime = 0L;
        this.mOtherCostTime = 0L;
        this.mLaunchCostTime = 0L;
        this.mLaunchStartTime = 0L;
        this.mTotalCostTime = 0L;
        this.mPreviousActivity = null;
        Activity activity = ActivityUtils.getTopActivity();
        if (activity != null) {
            this.mPreviousActivity = activity.getClass().getCanonicalName();
        }
    }

    public void paused() {
        this.mPauseCostTime = SystemClock.elapsedRealtime() - this.mStartTime;
    }

    public void launch() {
        if (this.mStartTime == 0L) {
            this.mStartTime = SystemClock.elapsedRealtime();
            this.mPauseCostTime = 0L;
            this.mRenderCostTime = 0L;
            this.mOtherCostTime = 0L;
            this.mLaunchCostTime = 0L;
            this.mLaunchStartTime = 0L;
            this.mTotalCostTime = 0L;
        }
        this.mLaunchStartTime = SystemClock.elapsedRealtime();
        this.mLaunchCostTime = 0L;
    }

    public void launchEnd() {
        this.mLaunchCostTime = SystemClock.elapsedRealtime() - this.mLaunchStartTime;
        this.render();
    }

    public void render() {
        this.mRenderStartTime = SystemClock.elapsedRealtime();
        Activity activity = ActivityUtils.getTopActivity();
        if (activity != null && activity.getWindow() != null) {
            this.mCurrentActivity = activity.getClass().getCanonicalName();
            activity.getWindow().getDecorView().post(new Runnable(){

                @Override
                public void run() {
                    ActivityCounter.this.renderEnd();
                }
            });
        } else {
            this.renderEnd();
        }
    }

    public void enterBackground() {
        this.mStartTime = 0L;
    }

    private void renderEnd() {
        this.mRenderCostTime = SystemClock.elapsedRealtime() - this.mRenderStartTime;
        this.mTotalCostTime = SystemClock.elapsedRealtime() - this.mStartTime;
        this.mOtherCostTime = this.mTotalCostTime - this.mRenderCostTime - this.mPauseCostTime - this.mLaunchCostTime;
        this.print();
    }

    private void print() {
        CounterInfo counterInfo = new CounterInfo();
        counterInfo.time = SystemClock.elapsedRealtime();
        counterInfo.type = 1;
        counterInfo.title = this.mPreviousActivity + " -> " + this.mCurrentActivity;
        counterInfo.launchCost = this.mLaunchCostTime;
        counterInfo.pauseCost = this.mPauseCostTime;
        counterInfo.renderCost = this.mRenderCostTime;
        counterInfo.totalCost = this.mTotalCostTime;
        counterInfo.otherCost = this.mOtherCostTime;
        try {
            if (DoKitManager.APP_HEALTH_RUNNING && !ActivityUtils.getTopActivity().getClass().getCanonicalName().equals("com.didichuxing.doraemonkit.kit.base.UniversalActivity")) {
                AppHealthInfo.DataBean.PageLoadBean pageLoadBean = new AppHealthInfo.DataBean.PageLoadBean();
                pageLoadBean.setPage(ActivityUtils.getTopActivity().getClass().getCanonicalName());
                pageLoadBean.setTime("" + counterInfo.totalCost);
                pageLoadBean.setTrace(counterInfo.title);
                AppHealthInfoUtil.getInstance().addPageLoadInfo(pageLoadBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mCounterInfos.add(counterInfo);
        TimeCounterDokitView dokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), TimeCounterDokitView.class);
        if (dokitView != null) {
            dokitView.showInfo(counterInfo);
        }
    }

    public List<CounterInfo> getHistory() {
        return this.mCounterInfos;
    }
}

