/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.os.Looper;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.aop.DokitPluginConfig;
import com.didichuxing.doraemonkit.aop.method_stack.MethodStackUtil;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.methodtrace.AppHealthMethodCostBean;
import com.didichuxing.doraemonkit.kit.methodtrace.AppHealthMethodCostBeanWrap;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterDokitView;
import com.didichuxing.doraemonkit.kit.timecounter.bean.CounterInfo;
import com.didichuxing.doraemonkit.kit.timecounter.counter.ActivityCounter;
import com.didichuxing.doraemonkit.kit.timecounter.counter.AppCounter;
import com.didichuxing.doraemonkit.util.GsonUtils;
import java.util.ArrayList;
import java.util.List;

public class TimeCounterManager {
    private static final String TAG = "TimeCounterManager";
    private boolean mIsRunning;
    private AppCounter mAppCounter = new AppCounter();
    private ActivityCounter mActivityCounter = new ActivityCounter();

    public static TimeCounterManager get() {
        return Holder.INSTANCE;
    }

    public void onAppAttachBaseContextStart() {
        this.mAppCounter.attachStart();
    }

    public void onAppAttachBaseContextEnd() {
        this.mAppCounter.attachEnd();
    }

    public void onAppCreateStart() {
        this.mAppCounter.start();
    }

    public void onAppCreateEnd() {
        this.mAppCounter.end();
        CounterInfo counterInfo = this.getAppSetupInfo();
        if (DokitPluginConfig.VALUE_METHOD_STRATEGY == DokitPluginConfig.STRATEGY_STACK) {
            StringBuilder startInfo = new StringBuilder();
            startInfo.append(MethodStackUtil.STR_APP_ATTACH_BASECONTEXT);
            startInfo.append("\n");
            startInfo.append(MethodStackUtil.STR_APP_ON_CREATE);
            AppHealthInfoUtil.getInstance().setAppStartInfo(counterInfo.totalCost, startInfo.toString(), new ArrayList<AppHealthInfo.DataBean.AppStartBean.LoadFuncBean>());
        } else {
            ArrayList<AppHealthMethodCostBean> appHealthMethodCostBeans = new ArrayList<AppHealthMethodCostBean>();
            AppHealthMethodCostBean onCreate2 = new AppHealthMethodCostBean();
            onCreate2.setCostTime(this.mAppCounter.getStartCountTime() + "ms");
            onCreate2.setFunctionName("Application onCreate");
            appHealthMethodCostBeans.add(onCreate2);
            AppHealthMethodCostBean onAttach = new AppHealthMethodCostBean();
            onAttach.setCostTime(this.mAppCounter.getAttachCountTime() + "ms");
            onAttach.setFunctionName("Application attachBaseContext");
            appHealthMethodCostBeans.add(onAttach);
            AppHealthMethodCostBeanWrap appHealthMethodCostBeanWrap = new AppHealthMethodCostBeanWrap();
            appHealthMethodCostBeanWrap.setTitle("App\u542f\u52a8\u8017\u65f6");
            appHealthMethodCostBeanWrap.setData(appHealthMethodCostBeans);
            AppHealthInfoUtil.getInstance().setAppStartInfo(counterInfo.totalCost, GsonUtils.toJson((Object)appHealthMethodCostBeanWrap), new ArrayList<AppHealthInfo.DataBean.AppStartBean.LoadFuncBean>());
        }
    }

    public void onActivityPause() {
        this.mActivityCounter.pause();
    }

    public void onActivityPaused() {
        this.mActivityCounter.paused();
    }

    public void onActivityLaunch() {
        this.mActivityCounter.launch();
    }

    public void onActivityLaunched() {
        this.mActivityCounter.launchEnd();
    }

    public void onEnterBackground() {
        this.mActivityCounter.enterBackground();
    }

    public void start() {
        if (this.mIsRunning) {
            return;
        }
        this.mIsRunning = true;
        DoKit.hideToolPanel();
        DoKit.launchFloating(TimeCounterDokitView.class);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void stop() {
        if (!this.mIsRunning) {
            return;
        }
        Looper.getMainLooper().setMessageLogging(null);
        this.mIsRunning = false;
        DoKit.removeFloating(TimeCounterDokitView.class);
    }

    public List<CounterInfo> getHistory() {
        return this.mActivityCounter.getHistory();
    }

    public CounterInfo getAppSetupInfo() {
        return this.mAppCounter.getAppSetupInfo();
    }

    private static class Holder {
        private static TimeCounterManager INSTANCE = new TimeCounterManager();

        private Holder() {
        }
    }
}

