/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterListFragment;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterManager;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;

public class TimeCounterFragment
extends BaseFragment {
    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_time_counter_index;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        HomeTitleBar title = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        title.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                TimeCounterFragment.this.getActivity().finish();
            }
        });
        RecyclerView mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        SettingItemAdapter settingItemAdapter = new SettingItemAdapter(this.getContext());
        mSettingList.setAdapter((RecyclerView.Adapter)settingItemAdapter);
        settingItemAdapter.append(new SettingItem(R.string.dk_item_time_counter_switch, TimeCounterManager.get().isRunning()));
        settingItemAdapter.append(new SettingItem(R.string.dk_item_time_goto_list));
        settingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_item_time_counter_switch) {
                    if (on) {
                        TimeCounterManager.get().start();
                    } else {
                        TimeCounterManager.get().stop();
                    }
                }
            }
        });
        settingItemAdapter.setOnSettingItemClickListener(new SettingItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
                if (data.desc == R.string.dk_item_time_goto_list) {
                    TimeCounterFragment.this.showContent(TimeCounterListFragment.class);
                }
            }
        });
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

