/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.sysinfo;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.aop.DokitThirdLibInfo;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.sysinfo.SysInfoItem;
import com.didichuxing.doraemonkit.kit.sysinfo.ThirdLibInfoItemAdapter;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ThirdLibInfoFragment
extends BaseFragment {
    private RecyclerView mInfoList;
    private ThirdLibInfoItemAdapter mInfoItemAdapter;
    private EditText mEditText;
    private RadioGroup mSortGroup;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_third_lib_info;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.initView();
            this.initData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        this.mInfoList = (RecyclerView)this.findViewById(R.id.info_list);
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                ThirdLibInfoFragment.this.getActivity().finish();
            }
        });
        this.mEditText = (EditText)this.findViewById(R.id.edittext);
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String keyWords = s.toString().trim();
                if (keyWords.isEmpty()) {
                    ThirdLibInfoFragment.this.initData();
                } else {
                    ThirdLibInfoFragment.this.notifyThirdKeyWordsLibInfos(keyWords);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mInfoList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mInfoItemAdapter = new ThirdLibInfoItemAdapter(this.getContext());
        this.mInfoList.setAdapter((RecyclerView.Adapter)this.mInfoItemAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mInfoList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mSortGroup = (RadioGroup)this.findViewById(R.id.sort_option);
        this.mSortGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                ThirdLibInfoFragment.this.mInfoItemAdapter.setData(ThirdLibInfoFragment.this.sortSysInfoItems(null));
            }
        });
        if (DokitThirdLibInfo.THIRD_LIB_INFOS == null || DokitThirdLibInfo.THIRD_LIB_INFOS.isEmpty()) {
            ToastUtils.showShort((CharSequence)"\u68c0\u67e5gradle.properties\u4e2d\u7684DOKIT_THIRD_LIB_SWITCH\u503c\u662f\u5426\u4e3atrue");
        }
    }

    private void initData() {
        ArrayList<SysInfoItem> sysInfoItems = new ArrayList<SysInfoItem>();
        this.addThirdLibInfos(sysInfoItems);
        this.mInfoItemAdapter.setData(this.sortSysInfoItems(sysInfoItems));
    }

    private void addThirdLibInfos(List<SysInfoItem> sysInfoItems) {
        for (Map.Entry<String, String> entry : DokitThirdLibInfo.THIRD_LIB_INFOS.entrySet()) {
            sysInfoItems.add(new SysInfoItem(entry.getKey(), entry.getValue()));
        }
    }

    private List<SysInfoItem> sortSysInfoItems(List<SysInfoItem> sysInfoItems) {
        List<SysInfoItem> data;
        List<SysInfoItem> list = data = sysInfoItems == null ? this.mInfoItemAdapter.getData() : sysInfoItems;
        if (this.mSortGroup.getCheckedRadioButtonId() == R.id.sort_size) {
            Collections.sort(data, new Comparator<SysInfoItem>(){

                @Override
                public int compare(SysInfoItem o1, SysInfoItem o2) {
                    return (int)(Long.parseLong(o2.value) - Long.parseLong(o1.value));
                }
            });
        } else {
            Collections.sort(data, new Comparator<SysInfoItem>(){

                @Override
                public int compare(SysInfoItem o1, SysInfoItem o2) {
                    return o1.name.compareToIgnoreCase(o2.name);
                }
            });
        }
        return data;
    }

    private void notifyThirdKeyWordsLibInfos(String keyWords) {
        ArrayList<SysInfoItem> sysInfoItems = new ArrayList<SysInfoItem>();
        for (Map.Entry<String, String> entry : DokitThirdLibInfo.THIRD_LIB_INFOS.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(keyWords.toLowerCase()) && !entry.getKey().toLowerCase().contains(keyWords.toLowerCase())) continue;
            sysInfoItems.add(new SysInfoItem(entry.getKey(), entry.getValue()));
        }
        this.mInfoItemAdapter.setData(this.sortSysInfoItems(sysInfoItems));
    }
}

