/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.sysinfo;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.sysinfo.SysInfoItem;
import com.didichuxing.doraemonkit.kit.sysinfo.TitleItem;
import com.didichuxing.doraemonkit.util.PermissionUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;
import com.didichuxing.doraemonkit.widget.textview.LabelTextView;

public class SysInfoItemAdapter
extends AbsRecyclerAdapter<AbsViewBinder<SysInfoItem>, SysInfoItem> {
    private static final int TYPE_ITEM = 0;
    private static final int TYPE_TITLE = 1;

    public SysInfoItemAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<SysInfoItem> createViewHolder(View view, int viewType) {
        if (viewType == 1) {
            return new TitleItemViewHolder(view);
        }
        return new SysInfoItemViewHolder(view);
    }

    public int getItemViewType(int position) {
        if (this.getData().get(position) instanceof TitleItem) {
            return 1;
        }
        return 0;
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return inflater.inflate(R.layout.dk_item_sys_title, parent, false);
        }
        return inflater.inflate(R.layout.dk_item_sys_info, parent, false);
    }

    public class TitleItemViewHolder
    extends AbsViewBinder<SysInfoItem> {
        private TextView mTextView;

        public TitleItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.mTextView = (TextView)this.getView(R.id.tv_title);
        }

        @Override
        public void bind(SysInfoItem sysInfoItem) {
            this.mTextView.setText((CharSequence)sysInfoItem.name);
        }
    }

    public class SysInfoItemViewHolder
    extends AbsViewBinder<SysInfoItem> {
        private LabelTextView mLabelText;

        public SysInfoItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.mLabelText = (LabelTextView)((Object)this.getView(R.id.label_text));
        }

        @Override
        public void bind(final SysInfoItem sysInfoItem) {
            this.mLabelText.setLabel(sysInfoItem.name);
            this.mLabelText.setText(sysInfoItem.value);
            this.mLabelText.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (sysInfoItem.isPermission) {
                        PermissionUtils.launchAppDetailsSettings();
                    }
                }
            });
        }
    }
}

