/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.kit.performance.datasource.IDataSource;
import com.didichuxing.doraemonkit.kit.performance.widget.LineData;
import com.didichuxing.doraemonkit.kit.performance.widget.LineRender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CardiogramView
extends View
implements Runnable {
    private static final float DEFAULT_ITEM_COUNT = 12.0f;
    private static final float MAX_ITEM_COUNT = 14.0f;
    private static final int DEFAULT_FRAME_DELAY = 32;
    private static final int DEFAULT_FRAME_COUNT = 62;
    private float mItemWidth;
    private int mTotalFrameCount = 62;
    private int mCurrentFrameCount = 0;
    private LineRender mRender;
    private List<LineData> mList = Collections.synchronizedList(new ArrayList());
    private IDataSource mDataSource;
    private Handler mHandler = new Handler();

    public CardiogramView(Context context) {
        super(context);
        this.init(context);
    }

    public CardiogramView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mRender = new LineRender(context);
        this.mRender.setMaxValue(100);
        this.mRender.setMinValue(0);
        this.mRender.setPointSize(5.0f);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mItemWidth = (float)w / 12.0f;
        this.mRender.measure(this.mItemWidth, h);
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        float translateX = this.getCanvasTranslate();
        canvas.translate(translateX, 0.0f);
        this.drawLine(canvas);
        this.checkFirstItemBound();
        canvas.restore();
    }

    private void checkFirstItemBound() {
        ++this.mCurrentFrameCount;
        if (this.mCurrentFrameCount >= this.mTotalFrameCount) {
            this.mCurrentFrameCount = 0;
            if (this.mDataSource != null) {
                this.mList.add(this.mDataSource.createData());
            }
            if ((float)this.mList.size() > 14.0f) {
                this.mList.remove(0).release();
            }
        }
    }

    private float getCanvasTranslate() {
        return -this.mItemWidth * ((float)this.mCurrentFrameCount / (float)this.mTotalFrameCount) + this.mItemWidth * (14.0f - (float)this.mList.size());
    }

    private void drawLine(Canvas canvas) {
        int index = 0;
        while ((float)index < Math.min((float)this.mList.size(), 13.0f)) {
            this.mRender.setCurrentValue(index, this.mList.get((int)index).value);
            if (index == this.mList.size() - 2) {
                this.mRender.setShowLabel(true);
                this.mRender.setLabelAlpha(1.0f);
                this.mRender.setLabel(this.mList.get((int)index).label);
            } else if (index == this.mList.size() - 3) {
                this.mRender.setLabel(this.mList.get((int)index).label);
                this.mRender.setLabelAlpha(1.0f - (float)this.mCurrentFrameCount / (float)this.mTotalFrameCount);
                this.mRender.setShowLabel(true);
            } else {
                this.mRender.setLabel(this.mList.get((int)index).label);
                this.mRender.setShowLabel(false);
            }
            if (index == this.mList.size() - 1) {
                this.mRender.setNextValue(0.0f);
                this.mRender.setDrawRightLine(false);
            } else {
                this.mRender.setDrawRightLine(true);
                this.mRender.setNextValue(this.mList.get((int)(index + 1)).value);
            }
            this.mRender.draw(canvas);
            ++index;
        }
    }

    public void startMove() {
        this.mHandler.removeCallbacks((Runnable)this);
        this.mHandler.post((Runnable)this);
    }

    public void stopMove() {
        this.mHandler.removeCallbacks((Runnable)this);
    }

    public void setInterval(int milliSecond) {
        this.mTotalFrameCount = milliSecond / 32;
    }

    public void setDataSource(@NonNull IDataSource dataSource) {
        this.mDataSource = dataSource;
        this.mList.clear();
        this.mList.add(dataSource.createData());
    }

    @Override
    public void run() {
        this.invalidate();
        this.mHandler.postDelayed((Runnable)this, 32L);
    }
}

