/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance.datasource;

import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.utils.ByteUtil;
import com.didichuxing.doraemonkit.kit.performance.datasource.IDataSource;
import com.didichuxing.doraemonkit.kit.performance.widget.LineData;

public class NetworkDataSource
implements IDataSource {
    private static final String TAG = "NetworkDataSource";
    private long latestTotalLength = -1L;

    @Override
    public LineData createData() {
        long diff = 0L;
        long totalSize = NetworkManager.get().getTotalSize();
        if (this.latestTotalLength >= 0L && (diff = totalSize - this.latestTotalLength) < 0L) {
            diff = 0L;
        }
        this.latestTotalLength = totalSize;
        if (diff == 0L) {
            return LineData.obtain((float)Math.ceil((float)diff / 1024.0f), null);
        }
        return LineData.obtain((float)Math.ceil((float)diff / 1024.0f), ByteUtil.getPrintSize(diff));
    }
}

