/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance.datasource;

import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.kit.performance.datasource.CpuDataSource;
import com.didichuxing.doraemonkit.kit.performance.datasource.DefaultDataSource;
import com.didichuxing.doraemonkit.kit.performance.datasource.FpsDataSource;
import com.didichuxing.doraemonkit.kit.performance.datasource.IDataSource;
import com.didichuxing.doraemonkit.kit.performance.datasource.NetworkDataSource;
import com.didichuxing.doraemonkit.kit.performance.datasource.RamDataSource;

public class DataSourceFactory {
    public static final int TYPE_NETWORK = 1;
    public static final int TYPE_CPU = 2;
    public static final int TYPE_RAM = 3;
    public static final int TYPE_FPS = 4;

    @NonNull
    public static IDataSource createDataSource(int type) {
        switch (type) {
            case 1: {
                return new NetworkDataSource();
            }
            case 2: {
                return new CpuDataSource();
            }
            case 3: {
                return new RamDataSource();
            }
            case 4: {
                return new FpsDataSource();
            }
        }
        return new DefaultDataSource();
    }
}

