/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.didichuxing.doraemonkit.R;

public class PolyLineItemView
extends View {
    private static float pointBottomY;
    private static float pointTopY;
    private static Paint mGradientPaint;
    private final int GRAPH_STROKE_WIDTH = 2;
    private final float SMALL_RADIUS = 10.0f;
    private final float BIG_RADIUS = 20.0f;
    private final float CIRCLE_STROKE_WIDTH = 2.0f;
    private float maxValue;
    private float minValue;
    private float currentValue;
    private String label;
    private float lastValue;
    private float nextValue;
    private Paint mPaint = new Paint();
    private float viewHeight;
    private float viewWidth;
    private float pointX;
    private float pointY;
    private float pointSize = 10.0f;
    private boolean drawLeftLine = true;
    private boolean drawRightLine = true;
    private boolean onTouch = false;
    private boolean touchable = true;
    private boolean showLabel;
    private boolean drawDiver;

    public PolyLineItemView(Context context) {
        super(context);
    }

    public PolyLineItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PolyLineItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setCurrentValue(float currentValue) {
        if (currentValue > this.maxValue) {
            currentValue = (int)this.maxValue;
        }
        if (currentValue < this.minValue) {
            currentValue = (int)this.minValue;
        }
        this.currentValue = currentValue;
        this.invalidate();
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewHeight = this.getMeasuredHeight();
        this.viewWidth = this.getMeasuredWidth();
        this.pointX = this.viewWidth / 2.0f;
        if (pointBottomY == 0.0f) {
            pointBottomY = this.viewHeight - this.pointSize;
        }
        this.pointY = (1.0f - this.currentValue / (this.maxValue - this.minValue)) * (pointBottomY - pointTopY) + pointTopY;
        if (mGradientPaint == null) {
            mGradientPaint = new Paint();
            mGradientPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, this.viewWidth, this.viewHeight, this.getResources().getColor(R.color.dk_color_3300BFFF), this.getResources().getColor(R.color.dk_color_33434352), Shader.TileMode.CLAMP));
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawGraph(canvas);
        this.drawPoint(canvas);
        this.drawValue(canvas);
        this.drawLine(canvas);
    }

    private void drawValue(Canvas canvas) {
        if (this.onTouch || this.showLabel) {
            this.mPaint.setTextSize(20.0f);
            this.mPaint.setColor(-1);
            this.mPaint.setStrokeWidth(0.0f);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setTextAlign(Paint.Align.CENTER);
            Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
            float baseLine = this.pointY - fontMetrics.bottom * 4.0f;
            canvas.drawText(this.label, this.viewWidth / 2.0f, baseLine, this.mPaint);
        }
    }

    public void setlastValue(float lastValue) {
        if (lastValue > this.maxValue) {
            lastValue = (int)this.maxValue;
        }
        if (lastValue < this.minValue) {
            lastValue = (int)this.minValue;
        }
        this.lastValue = lastValue;
    }

    public void setNextValue(float nextValue) {
        if (nextValue > this.maxValue) {
            nextValue = (int)this.maxValue;
        }
        if (nextValue < this.minValue) {
            nextValue = (int)this.minValue;
        }
        this.nextValue = nextValue;
    }

    private void drawGraph(Canvas canvas) {
        float middleY;
        float middleValue;
        this.mPaint.setPathEffect(null);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_4c00C9F4));
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setAntiAlias(true);
        if (this.drawLeftLine) {
            middleValue = this.currentValue - (this.currentValue - this.lastValue) / 2.0f;
            middleY = (pointBottomY - pointTopY) * 1.0f / (this.maxValue - this.minValue) * (this.maxValue - middleValue + this.minValue) + pointTopY;
            canvas.drawLine(0.0f, middleY, this.pointX, this.pointY, this.mPaint);
            this.drawGradient(canvas, middleY, false);
        }
        if (this.drawRightLine) {
            middleValue = this.currentValue - (this.currentValue - this.nextValue) / 2.0f;
            middleY = (pointBottomY - pointTopY) * 1.0f / (this.maxValue - this.minValue) * (this.maxValue - middleValue + this.minValue) + pointTopY;
            canvas.drawLine(this.pointX, this.pointY, this.viewWidth, middleY, this.mPaint);
            this.drawGradient(canvas, middleY, true);
        }
    }

    private void drawGradient(Canvas canvas, float middleY, boolean isRight) {
        Path path = new Path();
        if (!isRight) {
            path.moveTo(0.0f, middleY);
            path.lineTo(this.pointX, this.pointY);
            path.lineTo(this.pointX, pointBottomY);
            path.lineTo(0.0f, pointBottomY);
        } else {
            path.moveTo(this.pointX, this.pointY);
            path.lineTo(this.pointX, pointBottomY);
            path.lineTo(this.pointX + this.viewWidth / 2.0f, pointBottomY);
            path.lineTo(this.pointX + this.viewWidth / 2.0f, middleY);
        }
        canvas.drawPath(path, mGradientPaint);
    }

    private void drawPoint(Canvas canvas) {
        int color2;
        if (this.onTouch) {
            color2 = this.getResources().getColor(R.color.dk_color_4c00C9F4);
            this.mPaint.setColor(color2);
            this.mPaint.setPathEffect(null);
            this.mPaint.setStrokeWidth(2.0f);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(this.pointX, this.pointY, 20.0f, this.mPaint);
        }
        color2 = this.getResources().getColor(R.color.dk_color_ff00C9F4);
        this.mPaint.setColor(color2);
        this.mPaint.setStrokeWidth(2.0f);
        canvas.drawCircle(this.pointX, this.pointY, this.pointSize, this.mPaint);
    }

    private void drawLine(Canvas canvas) {
        if (!this.drawDiver) {
            return;
        }
        this.mPaint.setColor(this.getResources().getColor(R.color.dk_color_999999));
        this.mPaint.setPathEffect(null);
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
        if (this.drawLeftLine) {
            canvas.drawLine(0.0f, pointBottomY, this.viewWidth / 2.0f, pointBottomY, this.mPaint);
        }
        if (this.drawRightLine) {
            canvas.drawLine(this.viewWidth / 2.0f, pointBottomY, this.viewWidth, pointBottomY, this.mPaint);
        }
    }

    public void setDrawLeftLine(boolean drawLeftLine) {
        this.drawLeftLine = drawLeftLine;
    }

    public void setDrawRightLine(boolean drawRightLine) {
        this.drawRightLine = drawRightLine;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.touchable) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.onTouch = true;
                this.setBackgroundResource(R.drawable.dk_line_chart_selected_background);
                break;
            }
            case 1: 
            case 3: {
                this.onTouch = false;
                this.setBackgroundResource(0);
            }
        }
        return super.onTouchEvent(event);
    }

    public void setDrawDiver(boolean drawDiver) {
        this.drawDiver = drawDiver;
    }

    public void setPointSize(float pointSize) {
        if (pointSize != 0.0f) {
            this.pointSize = pointSize;
        }
    }

    public void setTouchable(boolean touchable) {
        this.touchable = touchable;
    }

    public void showLabel(boolean showLatestLabel) {
        this.showLabel = showLatestLabel;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    static {
        pointTopY = 50.0f;
    }
}

