/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.performance.PerformanceData;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDataAdapter;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDataManager;
import com.didichuxing.doraemonkit.kit.performance.PolyLineAdapter;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PerformanceFragment
extends BaseFragment {
    public static final int CPU = 0;
    public static final int RAM = 1;
    public static final int FPS = 2;
    private PerformanceDataAdapter performanceDataAdapter;
    private PolyLineAdapter adapter;
    private TextView parameter;
    private TextView time;
    private TextView date;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_cpu_cache_log;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PerformanceDataManager.getInstance().init();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initview();
    }

    private void initview() {
        TitleBar titleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                PerformanceFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
        RecyclerView dataShow = (RecyclerView)this.findViewById(R.id.data_show);
        PolyLineAdapter.Builder builder = new PolyLineAdapter.Builder((Context)this.getActivity(), 10);
        dataShow.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 0, false));
        RecyclerView detail = (RecyclerView)this.findViewById(R.id.data_detail);
        detail.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.performanceDataAdapter = new PerformanceDataAdapter((Context)this.getActivity());
        detail.setAdapter((RecyclerView.Adapter)this.performanceDataAdapter);
        TextView model = (TextView)this.findViewById(R.id.model);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            int type = arguments.getInt("performance_type", 0);
            if (type == 1) {
                builder.setMaxValue((int)PerformanceDataManager.getInstance().getMaxMemory()).setMinValue(0);
                model.setText(R.string.dk_frameinfo_ram);
                new LoadDataTask().execute(new String[]{PerformanceDataManager.getInstance().getMemoryFilePath()});
            } else if (type == 2) {
                builder.setMaxValue(100).setMinValue(0);
                model.setText(R.string.dk_frameinfo_fps);
                new LoadDataTask().execute(new String[]{PerformanceDataManager.getInstance().getFpsFilePath()});
            } else {
                builder.setMaxValue(100).setMinValue(0);
                model.setText(R.string.dk_frameinfo_cpu);
                new LoadDataTask().execute(new String[]{PerformanceDataManager.getInstance().getCpuFilePath()});
            }
        }
        this.adapter = builder.build();
        dataShow.setAdapter((RecyclerView.Adapter)this.adapter);
        this.parameter = (TextView)this.findViewById(R.id.parameter);
        this.time = (TextView)this.findViewById(R.id.time);
        this.date = (TextView)this.findViewById(R.id.date);
        this.performanceDataAdapter.setOnViewClickListener(new PerformanceDataAdapter.OnViewClickListener(){

            @Override
            public void onViewClick(View v, PerformanceData data) {
                PerformanceFragment.this.updateTips(data);
            }
        });
        this.adapter.setOnViewClickListener(new PolyLineAdapter.OnViewClickListener(){

            @Override
            public void onViewClick(int position, PerformanceData data) {
                PerformanceFragment.this.updateTips(data);
            }
        });
    }

    private void updateTips(PerformanceData data) {
        this.parameter.setText((CharSequence)String.valueOf(data.parameter));
        this.time.setText((CharSequence)data.time);
        this.date.setText((CharSequence)data.date);
    }

    private class LoadDataTask
    extends AsyncTask<String, Integer, List<PerformanceData>> {
        private LoadDataTask() {
        }

        protected void onPostExecute(List<PerformanceData> result2) {
            PerformanceFragment.this.performanceDataAdapter.append(result2);
            PerformanceFragment.this.adapter.setData(result2);
            if (result2.size() > 1) {
                PerformanceFragment.this.updateTips(result2.get(1));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List doInBackground(String ... strings) {
            File file = new File(strings[0]);
            ArrayList<PerformanceData> datas = new ArrayList<PerformanceData>();
            if (file.exists()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    while ((tempString = reader.readLine()) != null) {
                        String[] split = tempString.split(" ");
                        datas.add(new PerformanceData(split[1], split[2], Float.valueOf(split[0]).floatValue()));
                    }
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            return datas;
        }
    }
}

